/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.search.FederatedIndexer;
import org.jboss.portal.search.IndexingException;
import org.jboss.portal.search.federation.IndexFederation;

public class IndexFederationService
extends AbstractJBossService
implements IndexFederation {
    private Map registry = new HashMap();

    public synchronized void register(FederatedIndexer federatedIndexer) {
        if (federatedIndexer == null) {
            throw new IllegalArgumentException("No null indexer");
        }
        String id = federatedIndexer.getId();
        if (this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Attempting dual registration of " + id);
        }
        HashMap<String, FederatedIndexer> copy = new HashMap<String, FederatedIndexer>(this.registry);
        copy.put(id, federatedIndexer);
        this.registry = copy;
    }

    public synchronized void unregister(String id) {
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (!this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Attempting to unregister unknown federated search service " + id);
        }
        HashMap copy = new HashMap(this.registry);
        copy.remove(id);
        this.registry = copy;
    }

    public void reindexAll() {
        if (this.registry != null) {
            for (FederatedIndexer federated : this.registry.values()) {
                int status = federated.getInfo().getStatus();
                if (status == 1) continue;
                ReindexFederatedIndexThread thread = new ReindexFederatedIndexThread(federated);
                thread.start();
            }
        }
    }

    public List getFederatedIndexerList() {
        return Collections.unmodifiableList(new ArrayList(this.registry.values()));
    }

    public FederatedIndexer getFederatedIndexer(String id) {
        return (FederatedIndexer)this.registry.get(id);
    }

    private class ReindexFederatedIndexThread
    extends Thread {
        private FederatedIndexer federated;

        public ReindexFederatedIndexThread(FederatedIndexer federated) {
            this.federated = federated;
        }

        public void run() {
            this.federated.getInfo().setStatus(1);
            try {
                this.federated.destroyIndex();
                this.federated.createIndex();
                this.federated.getInfo().setStatus(3);
            }
            catch (IndexingException e) {
                this.federated.getInfo().setStatus(2);
                e.printStackTrace();
            }
        }
    }
}

