/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.state;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.io.Serialization;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.controller.state.StateControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPageNavigationalStateSerialization
implements Serialization<PortletPageNavigationalState> {
    private static final Map<WindowState, Integer> windowStateToCode = new HashMap<WindowState, Integer>();
    private static final Map<Mode, Integer> modeToCode = new HashMap<Mode, Integer>();
    private static final Map<Integer, WindowState> codeToWindowState = new HashMap<Integer, WindowState>();
    private static final Map<Integer, Mode> codeToMode = new HashMap<Integer, Mode>();
    private final StateControllerContext context;

    public PortletPageNavigationalStateSerialization(StateControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    public void serialize(PortletPageNavigationalState pageNavigationalState, OutputStream out) throws IOException, IllegalArgumentException {
        DataOutputStream data = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        data.writeInt(pageNavigationalState.getPortletWindowIds().size());
        for (String windowId : pageNavigationalState.getPortletWindowIds()) {
            Integer value;
            data.writeUTF(windowId);
            PortletWindowNavigationalState windowNS = pageNavigationalState.getPortletWindowNavigationalState(windowId);
            byte header = 0;
            int decision = 0;
            if (windowNS.getPortletNavigationalState() != null) {
                header = (byte)(header | 1);
                decision |= 1;
            }
            if (windowNS.getWindowState() != null) {
                value = windowStateToCode.get(windowNS.getWindowState());
                if (value != null) {
                    header = (byte)(header | value << 1);
                } else {
                    header = (byte)(header | 8);
                    decision |= 2;
                }
            }
            if (windowNS.getMode() != null) {
                value = modeToCode.get(windowNS.getMode());
                if (value != null) {
                    header = (byte)(header | value << 4);
                } else {
                    header = (byte)(header | 0x40);
                    decision |= 4;
                }
            }
            data.writeByte(header);
            if (decision & true) {
                windowNS.getPortletNavigationalState().writeTo(data);
            }
            if ((decision & 2) != 0) {
                data.writeUTF(windowNS.getWindowState().toString());
            }
            if ((decision & 4) == 0) continue;
            data.writeUTF(windowNS.getMode().toString());
        }
        Set<QName> publicNames = pageNavigationalState.getPublicNames();
        data.writeInt(publicNames.size());
        for (QName name : pageNavigationalState.getPublicNames()) {
            data.writeUTF(name.getNamespaceURI());
            data.writeUTF(name.getLocalPart());
            String[] values = pageNavigationalState.getPublicNavigationalState(name);
            int length = values.length;
            data.writeInt(length);
            for (String value : values) {
                data.writeUTF(value);
            }
        }
        data.flush();
    }

    public PortletPageNavigationalState unserialize(InputStream in) throws IOException, IllegalArgumentException {
        DataInputStream data = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        PortletPageNavigationalState pageNS = this.context.createPortletPageNavigationalState(true);
        int size = data.readInt();
        while (size-- > 0) {
            String windowId = data.readUTF();
            byte header = data.readByte();
            StateString portletNS = null;
            if ((header & 1) != 0) {
                portletNS = StateString.create((DataInputStream)data);
            }
            WindowState windowState = null;
            int windowStateHeader = (header & 0xE) >> 1;
            switch (windowStateHeader) {
                case 0: {
                    break;
                }
                case 4: {
                    windowState = WindowState.create((String)data.readUTF());
                    break;
                }
                default: {
                    windowState = codeToWindowState.get(windowStateHeader);
                }
            }
            Mode mode = null;
            int modeStateHeader = (header & 0x70) >> 4;
            switch (modeStateHeader) {
                case 0: {
                    break;
                }
                case 4: {
                    mode = Mode.create((String)data.readUTF());
                    break;
                }
                default: {
                    mode = codeToMode.get(modeStateHeader);
                }
            }
            PortletWindowNavigationalState windowNS = new PortletWindowNavigationalState(portletNS, mode, windowState);
            pageNS.setPortletWindowNavigationalState(windowId, windowNS);
        }
        size = data.readInt();
        while (size-- > 0) {
            String namespaceURI = data.readUTF();
            String localName = data.readUTF();
            QName name = new QName(namespaceURI, localName);
            int length = data.readInt();
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = data.readUTF();
            }
            pageNS.setPublicNavigationalState(name, values);
        }
        return pageNS;
    }

    static {
        windowStateToCode.put(WindowState.NORMAL, 1);
        windowStateToCode.put(WindowState.MINIMIZED, 2);
        windowStateToCode.put(WindowState.MAXIMIZED, 3);
        codeToWindowState.put(1, WindowState.NORMAL);
        codeToWindowState.put(2, WindowState.MINIMIZED);
        codeToWindowState.put(3, WindowState.MAXIMIZED);
        modeToCode.put(Mode.VIEW, 1);
        modeToCode.put(Mode.EDIT, 2);
        modeToCode.put(Mode.HELP, 3);
        codeToMode.put(1, Mode.VIEW);
        codeToMode.put(2, Mode.EDIT);
        codeToMode.put(3, Mode.HELP);
    }
}

