/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.google;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.namespace.QName;
import org.jboss.portal.api.content.SelectedContent;
import org.jboss.portal.widget.AbstractWidgetPortlet;
import org.jboss.portal.widget.Widget;
import org.jboss.portal.widget.WidgetProvider;
import org.jboss.portal.widget.google.provider.GGProvider;

public class GGWidgetPortlet
extends AbstractWidgetPortlet {
    private static final QName CONTENT_SELECT = new QName("urn:jboss:portal:content", "select");
    private GGProvider provider = new GGProvider();

    protected WidgetProvider getProvider() {
        return this.provider;
    }

    public void processAction(ActionRequest req, ActionResponse resp) throws PortletException, PortletSecurityException, IOException {
        String contentURI;
        if (req.getParameter("content.action.select") != null && (contentURI = req.getParameter("content.uri")) != null) {
            String pickMethod;
            String queryParam;
            String numberOfResults;
            String currentPage;
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("content.uri", new String[]{contentURI});
            HashMap<String, String> widgetParams = new HashMap<String, String>();
            for (Map.Entry entry : req.getParameterMap().entrySet()) {
                String contentParamName = (String)entry.getKey();
                if (!contentParamName.startsWith("content.param")) continue;
                String[] contentParamValue = (String[])entry.getValue();
                params.put(contentParamName, contentParamValue);
                widgetParams.put(contentParamName, contentParamValue[0]);
            }
            String catParam = req.getParameter("cat");
            if (catParam != null) {
                params.put("cat", new String[]{catParam});
            }
            if ((currentPage = req.getParameter("currentPage")) != null) {
                params.put("currentPage", new String[]{currentPage});
            }
            if ((numberOfResults = req.getParameter("numberOfResults")) != null) {
                params.put("numberOfResults", new String[]{numberOfResults});
            }
            if ((queryParam = req.getParameter("query")) != null) {
                params.put("query", new String[]{queryParam});
            }
            if ((pickMethod = req.getParameter("gg_pick_method")) != null) {
                params.put("gg_pick_method", new String[]{pickMethod});
            }
            resp.setRenderParameters(params);
            resp.setEvent(CONTENT_SELECT, (Serializable)new SelectedContent(contentURI, widgetParams));
        }
    }

    protected void doView(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        String uri = req.getParameter("uri");
        Widget widget = this.provider.getWidget(uri);
        if (widget != null) {
            if (widget.getTitle() != null) {
                resp.setTitle(widget.getTitle().getString(req.getLocale(), true));
            }
            HashMap<String, String> parametersMap = new HashMap<String, String>();
            String[] parametersNames = req.getParameterValues("parameters");
            if (parametersNames != null) {
                for (String parameterName : parametersNames) {
                    String[] value = req.getParameterValues("parameters." + parameterName);
                    parametersMap.put(parameterName, value[0]);
                }
            }
            writer.print(widget.render(parametersMap, req.getLocale()));
        } else {
            writer.print("Widget is not available");
        }
        writer.close();
    }

    protected void doDispatch(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        if (this.EDIT_CONTENT.equals((Object)req.getPortletMode())) {
            this.doEditContent(req, resp);
        } else {
            super.doDispatch(req, resp);
        }
    }

    protected void doEditContent(RenderRequest req, RenderResponse resp) throws PortletException, PortletSecurityException, IOException {
        resp.setContentType("text/html");
        req.setAttribute("provider", (Object)this.provider);
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/edit_content.jsp");
        dispatcher.include(req, resp);
    }
}

