/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;

public class DialectFactory {
    private static final Map MAPPERS = new HashMap();

    private DialectFactory() {
    }

    public static String determineDialect(String databaseName, int databaseMajorVersion) {
        if (databaseName == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set");
        }
        DatabaseDialectMapper mapper = (DatabaseDialectMapper)MAPPERS.get(databaseName);
        if (mapper == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set for database: " + databaseName);
        }
        return mapper.getDialectClass(databaseMajorVersion);
    }

    static {
        MAPPERS.put("HSQL Database Engine", new VersionInsensitiveMapper("org.hibernate.dialect.HSQLDialect"));
        MAPPERS.put("DB2/NT", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.hibernate.dialect.MySQLDialect"));
        MAPPERS.put("PostgreSQL", new VersionInsensitiveMapper("org.hibernate.dialect.PostgreSQLDialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Sybase SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SybaseDialect"));
        MAPPERS.put("Informix Dynamic Server", new VersionInsensitiveMapper("org.hibernate.dialect.InformixDialect"));
        MAPPERS.put("Oracle", new DatabaseDialectMapper(){

            public String getDialectClass(int majorVersion) {
                return majorVersion > 8 ? "org.hibernate.dialect.Oracle9Dialect" : "org.hibernate.dialect.OracleDialect";
            }
        });
    }

    public static class VersionInsensitiveMapper
    implements DatabaseDialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String dialectClassName) {
            this.dialectClassName = dialectClassName;
        }

        public String getDialectClass(int majorVersion) {
            return this.dialectClassName;
        }
    }

    public static interface DatabaseDialectMapper {
        public String getDialectClass(int var1);
    }
}

