/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractBeanMetaData
extends AbstractFeatureMetaData
implements BeanMetaData {
    protected String bean;
    protected String name;
    protected ControllerMode mode = null;
    private Set properties;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected Set demands;
    protected Set supplies;
    protected Map metaData;

    public AbstractBeanMetaData() {
    }

    public AbstractBeanMetaData(String bean) {
        this.bean = bean;
    }

    public AbstractBeanMetaData(String name, String bean) {
        this.name = name;
        this.bean = bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
        this.flushJBossObjectCache();
    }

    public PropertyMetaData getProperty(String name) {
        if (this.properties != null && this.properties.size() > 0) {
            Iterator i = this.properties.iterator();
            while (i.hasNext()) {
                AbstractPropertyMetaData prop = (AbstractPropertyMetaData)i.next();
                if (!"properties".equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    public void addProperty(PropertyMetaData property) {
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        if (this.properties == null) {
            this.properties = new HashSet();
        }
        this.properties.add(property);
        this.flushJBossObjectCache();
    }

    public void setProperties(Set properties) {
        this.properties = properties;
        this.flushJBossObjectCache();
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public void setDemands(Set demands) {
        this.demands = demands;
        this.flushJBossObjectCache();
    }

    public void setSupplies(Set supplies) {
        this.supplies = supplies;
        this.flushJBossObjectCache();
    }

    public String getBean() {
        return this.bean;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    public ControllerMode getMode() {
        return this.mode;
    }

    public void setMode(ControllerMode mode) {
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    public Set getProperties() {
        return this.properties;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.create = lifecycle;
    }

    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.start = lifecycle;
    }

    public LifecycleMetaData getStop() {
        return this.stop;
    }

    public void setStop(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.stop = lifecycle;
    }

    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    public void setDestroy(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.destroy = lifecycle;
    }

    public Set getDemands() {
        return this.demands;
    }

    public Set getSupplies() {
        return this.supplies;
    }

    public Iterator getChildren() {
        ArrayList list = new ArrayList();
        this.getChildren(list);
        return list.iterator();
    }

    protected void getChildren(Collection collection) {
        if (this.classLoader != null) {
            collection.add(this.classLoader);
        }
        if (this.constructor != null) {
            collection.add(this.constructor);
        }
        if (this.properties != null) {
            collection.addAll(this.properties);
        }
        if (this.create != null) {
            collection.add(this.create);
        }
        if (this.start != null) {
            collection.add(this.start);
        }
        if (this.stop != null) {
            collection.add(this.stop);
        }
        if (this.destroy != null) {
            collection.add(this.destroy);
        }
        if (this.demands != null) {
            collection.addAll(this.demands);
        }
        if (this.supplies != null) {
            collection.addAll(this.supplies);
        }
        if (this.metaData != null) {
            collection.add(this.metaData);
        }
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" bean=").append(this.bean);
        buffer.append(" properties=");
        JBossObject.list((JBossStringBuilder)buffer, (Collection)this.properties);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append((Object)this.classLoader);
        }
        buffer.append(" constructor=").append((Object)this.constructor);
        if (this.create != null) {
            buffer.append(" create=").append((Object)this.create);
        }
        if (this.start != null) {
            buffer.append(" start=").append((Object)this.start);
        }
        if (this.stop != null) {
            buffer.append(" stop=").append((Object)this.stop);
        }
        if (this.destroy != null) {
            buffer.append(" destroy=").append((Object)this.destroy);
        }
        if (this.demands != null) {
            buffer.append(" demands=");
            JBossObject.list((JBossStringBuilder)buffer, (Collection)this.demands);
        }
        super.toString(buffer);
        if (this.supplies != null) {
            buffer.append(" supplies=");
            JBossObject.list((JBossStringBuilder)buffer, (Collection)this.supplies);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.bean);
        buffer.append('/');
        buffer.append(this.name);
    }
}

