/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPRoleModule;

public class LDAPRoleModuleImpl
extends LDAPRoleModule {
    private static final Logger log = Logger.getLogger(LDAPRoleModuleImpl.class);

    public Role findRoleByName(String name) throws IdentityException, IllegalArgumentException {
        Context ctx = null;
        try {
            LDAPRoleImpl role;
            log.debug((Object)("findRoleByName(): name = " + name));
            if (name == null) {
                throw new IdentityException("Role name canot be null");
            }
            String filter = "(".concat(this.getRidAttributeID()).concat("=").concat(name).concat(")");
            log.debug((Object)("Search filter: " + filter));
            List sr = this.searchRoles(filter, null);
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one role with id: " + name + "" + "Posible data inconsistency");
            }
            if (sr.size() == 0) {
                throw new IdentityException("No such role " + name);
            }
            SearchResult res = (SearchResult)sr.iterator().next();
            ctx = (DirContext)res.getObject();
            LDAPRoleImpl lDAPRoleImpl = role = this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace());
            return lDAPRoleImpl;
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No role found with name: " + name), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("Role search failed.", e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Failed to close LDAP connection", e);
                }
            }
        }
        throw new IdentityException("No role found with name: " + name);
    }

    public Set findRolesByNames(String[] names) throws IdentityException, IllegalArgumentException {
        if (names == null) {
            throw new IllegalArgumentException("null argument");
        }
        HashSet<LDAPRoleImpl> roles = new HashSet<LDAPRoleImpl>();
        try {
            StringBuffer filter = new StringBuffer("(| ");
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                filter.append("(").append(this.getRidAttributeID()).append("=").append(name).append(") ");
            }
            filter.append(")");
            List sr = this.searchRoles(filter.toString(), null);
            log.debug((Object)("Roles found: " + sr.size()));
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                roles.add(this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace()));
                ctx.close();
            }
        }
        catch (Exception e) {
            throw new IdentityException("Can't retreive roles", e);
        }
        return roles;
    }

    public Role findRoleById(Object id) throws IdentityException, IllegalArgumentException {
        if (id == null) {
            throw new IdentityException("Cannot search role with null id");
        }
        if (!(id instanceof String)) {
            throw new IdentityException("Only String id is suppoted");
        }
        return this.findRoleById((String)id);
    }

    public Role findRoleById(String id) throws IdentityException, IllegalArgumentException {
        return this.findRoleByDN(id);
    }

    public Role createRole(String name, String displayName) throws IdentityException, IllegalArgumentException {
        if (name == null) {
            throw new IdentityException("Role name cannot be null");
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        LdapContext ctx = null;
        try {
            ctx = (LdapContext)ldapContext.lookup(this.getContainerDN());
            BasicAttributes attrs = new BasicAttributes(true);
            Map attributesToAdd = this.getAttributesToAdd();
            for (String attributeName : attributesToAdd.keySet()) {
                log.debug((Object)("adding attribute: " + attributeName));
                BasicAttribute attr = new BasicAttribute(attributeName);
                Set attributeValues = (Set)attributesToAdd.get(attributeName);
                for (String attrValue : attributeValues) {
                    log.debug((Object)("adding attribute value: " + attrValue));
                    attr.add(attrValue);
                }
                attrs.put(attr);
            }
            attrs.put(this.getRidAttributeID(), name);
            if (!this.getDisplayNameAttributeID().equals(this.getRidAttributeID())) {
                attrs.put(this.getDisplayNameAttributeID(), displayName);
            }
            String dn = this.getRidAttributeID().concat("=").concat(name);
            log.debug((Object)("creating ldap entry for: " + dn + "; " + attrs));
            ctx.createSubcontext(dn, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to create role", e);
        }
        finally {
            try {
                ldapContext.close();
                ctx.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        Role resultRole = this.findRoleByName(name);
        this.fireRoleCreatedEvent(resultRole.getId(), resultRole.getName());
        return resultRole;
    }

    public void removeRole(Object id) throws IdentityException, IllegalArgumentException {
        LDAPRoleImpl ldapr = (LDAPRoleImpl)this.findRoleById(id);
        if (ldapr == null) {
            throw new IdentityException("Cannot find role for removal");
        }
        if (ldapr.getDn() == null) {
            throw new IdentityException("Cannot obtain DN of role");
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("removing entry: " + ldapr.getDn()));
            ldapContext.unbind(ldapr.getDn());
            this.fireRoleDestroyedEvent(ldapr.getId(), ldapr.getName());
        }
        catch (Exception e) {
            throw new IdentityException("Failed to remove role: ", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public int getRolesCount() throws IdentityException {
        try {
            String filter = this.getRidAttributeID().concat("=").concat("*");
            log.debug((Object)("Search filter: " + filter));
            List sr = this.searchRoles(filter, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No roles found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("Role search failed.", e);
        }
        return 0;
    }

    public Set findRoles() throws IdentityException {
        HashSet<LDAPRoleImpl> rf = new HashSet<LDAPRoleImpl>();
        try {
            String filter = "(".concat(this.getRidAttributeID()).concat("=").concat("*").concat(")");
            log.debug((Object)("Search filter: " + filter));
            List results = this.searchRoles(filter, null);
            for (SearchResult res : results) {
                DirContext ctx = (DirContext)res.getObject();
                rf.add(this.createRoleInstance(res.getAttributes(), ctx.getNameInNamespace()));
                ctx.close();
            }
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No roles found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("Role search failed.", e);
        }
        return rf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchRoles(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(1);
            controls.setReturningObjFlag(true);
            filter = filter.replaceAll("\\\\", "\\\\\\\\");
            log.debug((Object)("Search filter: " + filter));
            results = filterArgs == null ? ldapContext.search(this.getContainerDN(), filter, controls) : ldapContext.search(this.getContainerDN(), filter, filterArgs, controls);
            List list = Tools.toList(results);
            return list;
        }
        finally {
            if (results != null) {
                results.close();
            }
            ldapContext.close();
        }
    }

    private Map getAttributesToAdd() throws IdentityException {
        Map attributesToAdd = this.getIdentityConfiguration().getOptions("roleCreateAttibutes");
        if (attributesToAdd == null) {
            throw new IdentityException("roleCreateAttibutes missing in configuration");
        }
        return attributesToAdd;
    }
}

