/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EJB;
import org.jboss.management.j2ee.EntityBeanMBean;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.statistics.EntityBeanStatsImpl;
import org.jboss.management.j2ee.statistics.RangeStatisticImpl;

public class EntityBean
extends EJB
implements EntityBeanMBean {
    private EntityBeanStatsImpl stats = new EntityBeanStatsImpl();
    private static Logger log = Logger.getLogger(EntityBean.class);

    public EntityBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName) throws MalformedObjectNameException, InvalidParentException {
        this(name, ejbModuleName, ejbContainerName, null, null);
    }

    public EntityBean(String name, ObjectName ejbModuleName, ObjectName ejbContainerName, String jndiName, String localJndiName) throws MalformedObjectNameException, InvalidParentException {
        super("EntityBean", name, ejbModuleName, ejbContainerName, jndiName, localJndiName);
    }

    public Stats getstats() {
        try {
            this.updateCommonStats(this.stats);
            ObjectName poolName = this.getContainerPoolName();
            RangeStatisticImpl pooledCount = (RangeStatisticImpl)this.stats.getReadyCount();
            Integer poolSize = (Integer)this.server.getAttribute(poolName, "CurrentSize");
            pooledCount.set(poolSize.longValue());
            ObjectName cacheName = this.getContainerCacheName();
            RangeStatisticImpl readyCount = (RangeStatisticImpl)this.stats.getReadyCount();
            Long count = (Long)this.server.getAttribute(cacheName, "CacheSize");
            readyCount.set(count);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "EntityBean { " + super.toString() + " } []";
    }
}

