/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;
import org.ajax4jsf.xml.serializer.OutputPropertiesFactory;
import org.ajax4jsf.xml.serializer.Serializer;
import org.ajax4jsf.xml.serializer.SerializerFactory;
import org.ajax4jsf.xml.serializer.TreeWalker;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.BufferedRenderResponseWrapper;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.ExceptionHandlerImpl;
import org.jboss.portletbridge.ExcludedRequestAttribute;
import org.jboss.portletbridge.StateId;
import org.jboss.portletbridge.application.PortletStateHolder;
import org.jboss.portletbridge.application.PortletWindowState;
import org.jboss.portletbridge.context.InitFacesContext;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.richfaces.RichFacesHelper;
import org.jboss.portletbridge.util.BridgeLogger;
import org.jboss.portletbridge.util.FacesConfig;
import org.jboss.portletbridge.util.WebXML;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxPortletBridge
implements Bridge,
ELContextListener,
BridgeConfig {
    public static final String VIEWID_HISTORY_PREFIX = "javax.portlet.faces.viewIdHistory.";
    private static final Logger log = BridgeLogger.BRIDGE.getLogger();
    private static final String EXCEPTION_HANDLER_CLASS_PARAMETER = ExceptionHandler.class.getName();
    public static final String AJAX_NAMESPACE_PARAMETER = "org.ajax4jsf.portlet.NAMESPACE";
    public static final String VIEW_ID_PARAMETERS = "org.jboss.portletbridge.VIEW_ID_PARAMETERS";
    private boolean initialized = false;
    private PortletConfig portletConfig;
    private ExceptionHandler exceptionHandler;
    private Lifecycle lifecycle;
    private FacesContextFactory facesContextFactory;
    private List<String> facesServletMappings;
    private Set<ExcludedRequestAttribute> excludedAttributes;
    private boolean preserveActionParams;
    private Map<String, String> defaultViewIdMap;
    private PortletStateHolder stateHolder;
    private Map<Class<? extends Throwable>, String> errorPages;
    public RichFacesHelper richFacesHelper;
    public boolean RICHFACES_ENABLED;
    private Application application;

    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Destroy portletbridge " + this.getPortletConfig().getPortletName());
        }
        this.lifecycle = null;
        this.facesContextFactory = null;
        this.stateHolder = null;
        this.initialized = false;
    }

    public void init(PortletConfig config) throws BridgeException {
        if (null == config) {
            throw new NullPointerException("No PortletConfig at the bridge initialization");
        }
        if (this.initialized) {
            throw new BridgeException("JSF portlet bridge already initialized");
        }
        String portletName = config.getPortletName();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start portletbridge initialization for " + portletName);
        }
        this.portletConfig = config;
        PortletContext portletContext = config.getPortletContext();
        this.stateHolder = PortletStateHolder.init(portletContext);
        this.initFaces(portletContext);
        this.transferLocales(config);
        this.exceptionHandler = this.createExceptionHandler(portletContext);
        WebXML webXml = new WebXML();
        webXml.parse(portletContext);
        this.facesServletMappings = webXml.getFacesServletMappings();
        if (null == this.facesServletMappings || this.facesServletMappings.size() == 0) {
            throw new BridgeException("Unable to get Faces Servlet mapping");
        }
        this.errorPages = webXml.getErrorViews();
        this.excludedAttributes = new HashSet<ExcludedRequestAttribute>();
        String bridgeParametersPrefix = "javax.portlet.faces." + portletName + ".";
        List<String> excluded = (List<String>)portletContext.getAttribute(bridgeParametersPrefix + "excludedRequestAttributes");
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        FacesConfig facesConfig = new FacesConfig();
        facesConfig.parse(portletContext);
        excluded = facesConfig.getExcludedAttributes();
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        Boolean preserveParams = (Boolean)portletContext.getAttribute(bridgeParametersPrefix + "preserveActionParams");
        this.preserveActionParams = Boolean.TRUE.equals(preserveParams);
        this.defaultViewIdMap = (Map)portletContext.getAttribute(bridgeParametersPrefix + "defaultViewIdMap");
        if (null == this.defaultViewIdMap || 0 == this.defaultViewIdMap.size()) {
            throw new BridgeException("No JSF view id's defined in portlet");
        }
        this.initialized = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Done portletbridge initialization for " + portletName);
        }
    }

    protected void initFaces(PortletContext portletContext) {
        try {
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
            if (null == lifecycleId) {
                lifecycleId = "DEFAULT";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Create instance of a JSF lifecycle " + lifecycleId);
            }
            this.lifecycle = factory.getLifecycle(lifecycleId);
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.lifecycle.getPhaseListeners();
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.application = appFactory.getApplication();
            this.application.addELContextListener((ELContextListener)this);
            try {
                this.richFacesHelper = new RichFacesHelper();
                this.RICHFACES_ENABLED = true;
            }
            catch (NoClassDefFoundError e) {
                this.richFacesHelper = null;
                this.RICHFACES_ENABLED = false;
            }
            if (this.RICHFACES_ENABLED) {
                String renderKitId = this.application.getDefaultRenderKitId();
                if (null == renderKitId) {
                    renderKitId = "HTML_BASIC";
                }
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                InitFacesContext context = new InitFacesContext(this.application, portletContext);
                RenderKit renderKit = renderKitFactory.getRenderKit((FacesContext)context, renderKitId);
                renderKit.addRenderer("javax.faces.ViewRoot", "javax.faces.ViewRoot", this.richFacesHelper.getViewRootRenderer());
                context.release();
            }
        }
        catch (FacesException e) {
            throw new BridgeException("JSF Initialization error", (Throwable)e);
        }
    }

    private Application getApplication() {
        return this.application;
    }

    protected void transferLocales(PortletConfig config) {
        try {
            Class<?> c = Class.forName("org.jboss.portal.portlet.impl.jsr168.api.PortletConfigImpl");
            Method method = c.getMethod("getSupportedLocales", new Class[0]);
            Object retobj = method.invoke((Object)config, null);
            Enumeration portletLocales = (Enumeration)retobj;
            ArrayList facesLocales = new ArrayList();
            while (portletLocales.hasMoreElements()) {
                facesLocales.add(portletLocales.nextElement());
            }
            this.getApplication().setSupportedLocales(facesLocales);
        }
        catch (ClassNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unable to set portlet locales into faces application");
            }
        }
        catch (IllegalAccessException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Error while setting locales in faces application");
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected ExceptionHandler createExceptionHandler(PortletContext portletContext) {
        String exceptionHandlerClassName = portletContext.getInitParameter(EXCEPTION_HANDLER_CLASS_PARAMETER);
        ExceptionHandler handler = null;
        if (null != exceptionHandlerClassName) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<ExceptionHandler> exceptionHandlerClass = classLoader.loadClass(exceptionHandlerClassName).asSubclass(ExceptionHandler.class);
                handler = exceptionHandlerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                handler = new ExceptionHandlerImpl();
            }
            catch (InstantiationException e) {
                handler = new ExceptionHandlerImpl();
            }
            catch (IllegalAccessException e) {
                handler = new ExceptionHandlerImpl();
            }
        } else {
            handler = new ExceptionHandlerImpl();
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException {
        if (null == request) {
            throw new NullPointerException("Request parameter is null");
        }
        if (null == response) {
            throw new NullPointerException("Response parameter is null");
        }
        if (!this.isInitialized()) {
            throw new BridgeException("JSF Portlet bridge is not initialized");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge action request processing for portlet " + this.getPortletName());
        }
        this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.ActionPhase);
        StateId stateId = this.getStateHolder().getStateId(this.getPortletName(), request);
        PortletWindowState windowState = new PortletWindowState(){

            public BridgeConfig getBridgeConfig() {
                return AjaxPortletBridge.this;
            }
        };
        PortletBridgeContext bridgeContext = this.createBridgeContext((PortletRequest)request, windowState);
        bridgeContext.setStateId(stateId);
        FacesContext facesContext = this.getFacesContext(request, response);
        try {
            this.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                Map viewIdParameters = (Map)facesContext.getExternalContext().getRequestMap().get(VIEW_ID_PARAMETERS);
                if (null != viewIdParameters && viewIdParameters.size() > 0) {
                    this.processPortletParameters(response, stateId, facesContext, facesContext.getViewRoot().getViewId(), viewIdParameters);
                }
                facesContext.getApplication().getStateManager().saveView(facesContext);
                windowState.saveRequest(facesContext);
            } else {
                windowState.reset();
                windowState.saveSeamConversationId(facesContext);
                String redirectViewId = bridgeContext.getRedirectViewId();
                if (null != redirectViewId) {
                    windowState.setViewId(redirectViewId);
                    Map<String, String[]> newRequestParameters = bridgeContext.getRedirectRequestParameters();
                    windowState.setRequestParameters(newRequestParameters);
                    this.processPortletParameters(response, stateId, facesContext, redirectViewId, newRequestParameters);
                }
            }
        }
        catch (Exception e) {
            this.exceptionHandler.processActionException(facesContext, windowState, e);
        }
        finally {
            this.getStateHolder().addWindowState(stateId, windowState);
            response.setRenderParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
            facesContext.release();
        }
    }

    public void processPortletParameters(ActionResponse response, StateId stateId, FacesContext facesContext, String redirectViewId, Map<String, String[]> newRequestParameters) throws MalformedURLException, PortletModeException {
        for (Map.Entry<String, String[]> entry : newRequestParameters.entrySet()) {
            String key = entry.getKey();
            if ("javax.portlet.faces.PortletMode".equals(key)) {
                String portletModeName = entry.getValue()[0];
                PortletMode mode = new PortletMode(portletModeName);
                PortalActionURL historyViewId = new PortalActionURL(redirectViewId);
                stateId.setMode(mode);
                historyViewId.setParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
                historyViewId.setParameter("javax.portlet.faces.PortletMode", portletModeName);
                facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + portletModeName, historyViewId.toString());
                response.setPortletMode(mode);
                continue;
            }
            if (!"javax.portlet.faces.WindowState".equals(key)) continue;
            try {
                WindowState state = new WindowState(entry.getValue()[0]);
                response.setWindowState(state);
            }
            catch (WindowStateException e) {}
        }
    }

    private PortletBridgeContext createBridgeContext(PortletRequest request, PortletWindowState windowState) {
        PortletBridgeContext bridgeContext = windowState.createBridgeContext();
        request.setAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME, (Object)bridgeContext);
        bridgeContext.setInitialRequestAttributeNames(request.getAttributeNames());
        return bridgeContext;
    }

    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException {
        if (null == request) {
            throw new NullPointerException("Request parameter is null");
        }
        if (null == response) {
            throw new NullPointerException("Response parameter is null");
        }
        if (!this.isInitialized()) {
            throw new BridgeException("JSF Portlet bridge is not initialized");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge render request processing for portlet " + this.getPortletName());
        }
        BufferedRenderResponseWrapper wrappedResponse = new BufferedRenderResponseWrapper(response);
        this.initRequest((PortletRequest)request, (PortletResponse)wrappedResponse, Bridge.PortletPhase.RenderPhase);
        String namespace = wrappedResponse.getNamespace();
        StateId stateId = this.getStateHolder().getStateId(this.getPortletName(), request, namespace);
        PortletWindowState windowState = this.getStateHolder().getWindowState(stateId);
        if (null == windowState) {
            windowState = new PortletWindowState(){

                public BridgeConfig getBridgeConfig() {
                    return AjaxPortletBridge.this;
                }
            };
            this.getStateHolder().addWindowState(stateId, windowState);
        }
        PortletBridgeContext bridgeContext = this.createBridgeContext((PortletRequest)request, windowState);
        bridgeContext.setStateId(stateId);
        FacesContext facesContext = this.getFacesContext(request, wrappedResponse);
        try {
            if (this.RICHFACES_ENABLED) {
                this.setupAjaxParams(facesContext, stateId.toString(), namespace);
            }
            windowState.restoreRequest(facesContext, true);
            ResourceBundle bundle = this.portletConfig.getResourceBundle(request.getLocale());
            if (bundle != null) {
                String title = null;
                try {
                    title = bundle.getString("javax.portlet.title");
                    wrappedResponse.setTitle(title);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.renderResponse(facesContext, windowState);
                String redirectViewId = bridgeContext.getRedirectViewId();
                if (null != redirectViewId) {
                    windowState.reset();
                    windowState.setViewId(redirectViewId);
                    Map<String, String[]> redirectParams = bridgeContext.getRedirectRequestParameters();
                    facesContext.release();
                    Set<String> initialAttributes = bridgeContext.getInitialRequestAttributeNames();
                    ArrayList<String> currentAttributes = Collections.list(request.getAttributeNames());
                    currentAttributes.removeAll(initialAttributes);
                    for (String newAttribute : currentAttributes) {
                        request.removeAttribute(newAttribute);
                    }
                    if (redirectParams != null) {
                        windowState.setRequestParameters(redirectParams);
                    }
                    facesContext = this.getFacesContext(request, wrappedResponse);
                    ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                    UIViewRoot viewRoot = viewHandler.createView(facesContext, redirectViewId);
                    facesContext.setViewRoot(viewRoot);
                    this.renderResponse(facesContext, windowState);
                }
                windowState.setViewId(facesContext.getViewRoot().getViewId());
            }
            catch (Exception e) {
                wrappedResponse.reset();
                log.log(Level.SEVERE, "Error processing execute lifecycle", e);
                this.exceptionHandler.processRenderException(facesContext, windowState, e);
            }
            String viewId = facesContext.getViewRoot().getViewId();
            String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, viewId);
            actionURL = facesContext.getExternalContext().encodeActionURL(actionURL);
            windowState.setPortalActionURL(new PortalActionURL(actionURL));
            PortletURL portletURL = wrappedResponse.createRenderURL();
            portletURL.setParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
            String renderUrl = portletURL.toString();
            windowState.setPortalRenderURL(new PortalActionURL(renderUrl));
            windowState.setNamespace(namespace);
            windowState.setPortletLocale(request.getLocale());
            String portletModeName = request.getPortletMode().toString();
            PortalActionURL historyViewId = new PortalActionURL(viewId);
            historyViewId.setParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
            historyViewId.setParameter("javax.portlet.faces.PortletMode", portletModeName);
            facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + portletModeName, historyViewId.toString());
            windowState.saveSeamConversationId(facesContext);
            PortletSession portletSession = (PortletSession)facesContext.getExternalContext().getSession(true);
            PortletStateHolder.WindowIDRetriver idRetriver = (PortletStateHolder.WindowIDRetriver)portletSession.getAttribute("org.jboss.portletbridge.WINDOW_ID_RETRIVER");
            if (null != idRetriver) {
                windowState.setWindowId(idRetriver.getWindowID());
            }
            Principal userPrincipal = facesContext.getExternalContext().getUserPrincipal();
            portletSession.setAttribute("org.jboss.portletbridge.USER_PRINCIPAL", (Object)userPrincipal, 1);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Finish rendering portletbridge for namespace " + namespace);
            }
            wrappedResponse.setProperty("portlet.expiration-cache", "0");
            if (this.RICHFACES_ENABLED) {
                this.richFacesHelper.getCurrentInstance();
                Object headEvents = request.getAttribute("org.ajax4jsf.framework.HEAD_EVENTS_LIST");
                if (headEvents != null) {
                    Node[] nodes = (Node[])headEvents;
                    Properties xhtmlProperties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xhtml");
                    Serializer serializer = SerializerFactory.getSerializer((Properties)xhtmlProperties);
                    if (wrappedResponse.isUseWriter()) {
                        serializer.setWriter((Writer)response.getWriter());
                    } else {
                        serializer.setOutputStream(response.getPortletOutputStream());
                    }
                    ContentHandler contentHandler = serializer.asContentHandler();
                    TreeWalker treeWalker = new TreeWalker(contentHandler);
                    contentHandler.startDocument();
                    for (Node node : nodes) {
                        treeWalker.traverseFragment(node);
                    }
                    contentHandler.endDocument();
                }
            }
            wrappedResponse.writeBufferedData();
        }
        catch (Exception e) {
            throw new BridgeException((Throwable)e);
        }
        finally {
            facesContext.release();
        }
    }

    private void setupAjaxParams(FacesContext facesContext, String stateId, String namespace) {
        Map commonAjaxParameters = this.richFacesHelper.getCurrentInstance(facesContext).getCommonAjaxParameters();
        commonAjaxParameters.put("javax.faces.portletbridge.STATE_ID", stateId);
        commonAjaxParameters.put(AJAX_NAMESPACE_PARAMETER, namespace);
    }

    private void renderResponse(FacesContext facesContext, PortletWindowState windowState) throws FacesException {
        if (null == facesContext.getViewRoot()) {
            this.execute(facesContext);
        }
        if (!facesContext.getResponseComplete()) {
            this.render(facesContext);
        }
    }

    protected void initRequest(PortletRequest request, PortletResponse response, Bridge.PortletPhase actionPhase) throws BridgeException {
        request.setAttribute("javax.portlet.faces.phase", (Object)actionPhase);
        Map<String, String> viewIdMap = this.getDefaultViewIdMap();
        String firstMode = viewIdMap.keySet().iterator().next();
        PortletSession portletSession = request.getPortletSession();
        if (null == portletSession.getAttribute(VIEWID_HISTORY_PREFIX + firstMode)) {
            for (Map.Entry<String, String> entry : viewIdMap.entrySet()) {
                portletSession.setAttribute(VIEWID_HISTORY_PREFIX + entry.getKey(), (Object)this.encodeModeParam(entry.getKey(), entry.getValue()));
            }
        }
    }

    private String encodeModeParam(String mode, String viewId) {
        try {
            PortalActionURL viewIdUrl = new PortalActionURL(viewId);
            viewIdUrl.addParameter("javax.portlet.faces.PortletMode", mode);
            return viewIdUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Malformed ViewId", (Throwable)e);
        }
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    protected Object getContext() {
        return this.portletConfig.getPortletContext();
    }

    @Override
    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (null == initParameter) {
            initParameter = this.portletConfig.getPortletContext().getInitParameter(name);
        }
        return initParameter;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public List<String> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    @Override
    public Set<ExcludedRequestAttribute> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Override
    public String getPortletName() {
        return this.portletConfig.getPortletName();
    }

    @Override
    public boolean isPreserveActionParams() {
        return this.preserveActionParams;
    }

    @Override
    public Map<String, String> getDefaultViewIdMap() {
        return this.defaultViewIdMap;
    }

    protected PortletStateHolder getStateHolder() {
        return this.stateHolder;
    }

    public void contextCreated(ELContextEvent event) {
        ELContext elContext = event.getELContext();
        if (elContext.getContext(PortletConfig.class) == null) {
            elContext.putContext(PortletConfig.class, (Object)this.portletConfig);
        }
    }

    @Override
    public Lifecycle getFacesLifecycle() {
        return this.lifecycle;
    }

    protected FacesContext getFacesContext(Object request, Object response) {
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getContext(), request, response, this.getFacesLifecycle());
        return facesContext;
    }

    protected void execute(FacesContext context) throws FacesException {
        this.getFacesLifecycle().execute(context);
    }

    protected void render(FacesContext context) throws FacesException {
        this.getFacesLifecycle().render(context);
    }

    @Override
    public Map<Class<? extends Throwable>, String> getErrorPages() {
        return this.errorPages;
    }
}

