/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.lifecycle;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.lifecycle.ApplyValuesPhase;
import org.jboss.portletbridge.lifecycle.LifecyclePhase;

public class RestoreViewPhase
extends LifecyclePhase {
    private static final Log _log = LogFactory.getLog(RestoreViewPhase.class);
    private final LifecyclePhase nextPhase;

    public RestoreViewPhase(Lifecycle lifecycle) {
        super(lifecycle);
        this.nextPhase = new ApplyValuesPhase(lifecycle);
    }

    public void execute(FacesContext context) {
        context.getApplication().getViewHandler().initView(context);
        super.execute(context);
    }

    protected void executeNextPhase(FacesContext context) {
        this.nextPhase.execute(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executePhase(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Found created UIViewRoot in facesContext");
            }
            viewRoot.setLocale(context.getExternalContext().getRequestLocale());
            this.processBindings(context, (UIComponent)viewRoot);
            return;
        } else {
            String viewId = this.calculateViewId(context);
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            if (this.isFacesRequest(context)) {
                viewRoot = viewHandler.restoreView(context, viewId);
                if (null == viewRoot) throw new ViewExpiredException("Error restore view " + viewId + ", session expired?");
                this.processBindings(context, (UIComponent)viewRoot);
            } else {
                viewRoot = viewHandler.createView(context, viewId);
                context.renderResponse();
            }
            context.setViewRoot(viewRoot);
        }
    }

    private boolean isFacesRequest(FacesContext context) {
        String renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        return this.getRenderKit(context, renderKitId).getResponseStateManager().isPostback(context);
    }

    private RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit(context, renderKitId);
    }

    private String calculateViewId(FacesContext context) {
        Object externalRequest = context.getExternalContext().getRequest();
        ExternalContext extContext = context.getExternalContext();
        String viewId = context.getExternalContext().getRequestPathInfo();
        if (null == viewId) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    private void processBindings(FacesContext context, UIComponent component) {
        ValueBinding binding = component.getValueBinding("binding");
        if (null != binding) {
            binding.setValue(context, (Object)component);
        }
        Iterator iterator = component.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent child = (UIComponent)iterator.next();
            this.processBindings(context, child);
        }
    }

    protected PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }
}

