/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class GossipClient {
    Timer timer = new Timer(true);
    final Hashtable groups = new Hashtable();
    private Refresher refresher_task = new Refresher();
    final Vector gossip_servers = new Vector();
    boolean timer_running = false;
    boolean refresher_enabled = true;
    long EXPIRY_TIME = 20000L;
    final int SOCKET_TIMEOUT = 5000;
    protected final Log log = LogFactory.getLog(this.getClass());

    public GossipClient(IpAddress gossip_host, long expiry) {
        this.init(gossip_host, expiry);
    }

    public GossipClient(Vector gossip_hosts, long expiry) {
        if (gossip_hosts == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"empty set of GossipRouters given");
            }
            return;
        }
        for (int i = 0; i < gossip_hosts.size(); ++i) {
            this.init((IpAddress)gossip_hosts.elementAt(i), expiry);
        }
    }

    public boolean isRefresherEnabled() {
        return this.refresher_enabled;
    }

    public void setRefresherEnabled(boolean refresher_enabled) {
        this.refresher_enabled = refresher_enabled;
    }

    public void stop() {
        this.timer_running = false;
        if (this.refresher_task != null) {
            this.refresher_task.cancel();
        }
        this.timer.cancel();
        this.groups.clear();
    }

    public void destroy() {
        this.timer_running = false;
        this.timer.cancel();
        this.groups.clear();
    }

    public void addGossipRouter(IpAddress gossip_host) {
        if (!this.gossip_servers.contains(gossip_host)) {
            this.gossip_servers.addElement(gossip_host);
        }
    }

    public void register(String group, Address mbr) {
        if (group == null || mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group or mbr is null");
            }
            return;
        }
        LinkedList<Address> mbrs = (LinkedList<Address>)this.groups.get(group);
        if (mbrs == null) {
            mbrs = new LinkedList<Address>();
            mbrs.add(mbr);
            this.groups.put(group, mbrs);
        } else if (!mbrs.contains(mbr)) {
            mbrs.add(mbr);
        }
        this._register(group, mbr);
        if (this.refresher_enabled && !this.timer_running) {
            this.timer = new Timer(true);
            this.refresher_task = new Refresher();
            this.timer.schedule((TimerTask)this.refresher_task, this.EXPIRY_TIME, this.EXPIRY_TIME);
            this.timer_running = true;
        }
    }

    public void unregister(String group, Address mbr) {
        if (group == null || mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group or mbr is null");
            }
            return;
        }
        this._unregister(group, mbr);
    }

    public List getMembers(String group) {
        if (group == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"group is null");
            }
            return null;
        }
        List result = this._getMembers(group);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("GET(" + group + ") --> " + result));
        }
        return result;
    }

    final void init(IpAddress gossip_host, long expiry) {
        this.EXPIRY_TIME = expiry;
        this.addGossipRouter(gossip_host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void _register(String group, Address mbr) {
        Socket sock = null;
        DataOutputStream out = null;
        for (int i = 0; i < this.gossip_servers.size(); ++i) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"entry.host or entry.port is null");
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("REGISTER(" + group + ", " + mbr + ") with GossipRouter at " + entry.getIpAddress() + ':' + entry.getPort()));
            }
            sock = new Socket(entry.getIpAddress(), entry.getPort());
            out = new DataOutputStream(sock.getOutputStream());
            GossipData gossip_req = new GossipData(3, group, mbr, null);
            gossip_req.writeTo(out);
            out.flush();
            Object var10_9 = null;
            Util.close(out);
            if (sock == null) continue;
            try {
                sock.close();
            }
            catch (IOException e) {}
            continue;
            {
                catch (Exception ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("exception connecting to host " + entry));
                    }
                    var10_9 = null;
                    Util.close(out);
                    if (sock == null) continue;
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_9 = null;
                Util.close(out);
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void _unregister(String group, Address mbr) {
        Socket sock = null;
        DataOutputStream out = null;
        for (int i = 0; i < this.gossip_servers.size(); ++i) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"entry.host or entry.port is null");
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("UNREGISTER(" + group + ", " + mbr + ") with GossipRouter at " + entry.getIpAddress() + ':' + entry.getPort()));
            }
            sock = new Socket(entry.getIpAddress(), entry.getPort());
            out = new DataOutputStream(sock.getOutputStream());
            GossipData gossip_req = new GossipData(7, group, mbr, null);
            gossip_req.writeTo(out);
            out.flush();
            Object var10_9 = null;
            Util.close(out);
            if (sock == null) continue;
            try {
                sock.close();
            }
            catch (IOException e) {}
            continue;
            {
                catch (Exception ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("exception connecting to host " + entry));
                    }
                    var10_9 = null;
                    Util.close(out);
                    if (sock == null) continue;
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_9 = null;
                Util.close(out);
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List _getMembers(String group) {
        LinkedList<Address> ret = new LinkedList<Address>();
        Socket sock = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        for (int i = 0; i < this.gossip_servers.size(); ++i) {
            IpAddress entry = (IpAddress)this.gossip_servers.elementAt(i);
            if (entry.getIpAddress() == null || entry.getPort() == 0) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"entry.host or entry.port is null");
                continue;
            }
            sock = new Socket();
            InetSocketAddress destAddr = new InetSocketAddress(entry.getIpAddress(), entry.getPort());
            sock.connect(destAddr, 5000);
            out = new DataOutputStream(sock.getOutputStream());
            GossipData gossip_req = new GossipData(4, group, null, null);
            gossip_req.writeTo(out);
            out.flush();
            in = new DataInputStream(sock.getInputStream());
            GossipData gossip_rsp = new GossipData();
            gossip_rsp.readFrom(in);
            if (gossip_rsp.mbrs != null) {
                Iterator it = gossip_rsp.mbrs.iterator();
                while (it.hasNext()) {
                    Address mbr = (Address)it.next();
                    if (ret.contains(mbr)) continue;
                    ret.add(mbr);
                }
            }
            Object var14_14 = null;
            Util.close(out);
            Util.close(in);
            if (sock == null) continue;
            try {
                sock.close();
            }
            catch (IOException e) {}
            continue;
            {
                catch (Exception ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("exception connecting to host " + entry));
                    }
                    var14_14 = null;
                    Util.close(out);
                    Util.close(in);
                    if (sock == null) continue;
                    try {
                        sock.close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                Util.close(out);
                Util.close(in);
                if (sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        Vector<IpAddress> gossip_hosts = new Vector<IpAddress>();
        boolean get = false;
        boolean register = false;
        boolean keep_running = false;
        String register_host = null;
        int register_port = 0;
        String get_group = null;
        String register_group = null;
        GossipClient gossip_client = null;
        long expiry = 20000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                GossipClient.usage();
                return;
            }
            if ("-expiry".equals(args[i])) {
                expiry = Long.parseLong(args[++i]);
                continue;
            }
            if ("-host".equals(args[i])) {
                String host = args[++i];
                int port = Integer.parseInt(args[++i]);
                try {
                    InetAddress ip_addr = InetAddress.getByName(host);
                    gossip_hosts.addElement(new IpAddress(ip_addr, port));
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            if ("-keep_running".equals(args[i])) {
                keep_running = true;
                continue;
            }
            if ("-get".equals(args[i])) {
                get = true;
                get_group = args[++i];
                continue;
            }
            if ("-register".equals(args[i])) {
                register_group = args[++i];
                register_host = args[++i];
                register_port = Integer.parseInt(args[++i]);
                register = true;
                continue;
            }
            GossipClient.usage();
            return;
        }
        if (gossip_hosts.size() == 0) {
            System.err.println("At least 1 GossipRouter has to be given");
            return;
        }
        if (!register && !get) {
            System.err.println("Neither get nor register command given, will not do anything");
            return;
        }
        try {
            gossip_client = new GossipClient(gossip_hosts, expiry);
            if (register) {
                System.out.println("Registering " + register_group + " --> " + register_host + ':' + register_port);
                gossip_client.register(register_group, new IpAddress(register_host, register_port));
            }
            if (get) {
                System.out.println("Getting members for group " + get_group);
                List mbrs = gossip_client.getMembers(get_group);
                System.out.println("Members for group " + get_group + " are " + mbrs);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        if (!keep_running) {
            gossip_client.stop();
        }
    }

    static void usage() {
        System.out.println("GossipClient [-help] [-host <hostname> <port>]+  [-get <groupname>] [-register <groupname hostname port>] [-expiry <msecs>] [-keep_running]]");
    }

    private class Refresher
    extends TimerTask {
        private Refresher() {
        }

        public void run() {
            int num_items = 0;
            if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace((Object)"refresher task is run");
            }
            Enumeration e = GossipClient.this.groups.keys();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                List mbrs = (List)GossipClient.this.groups.get(group);
                if (mbrs == null) continue;
                Iterator it = mbrs.iterator();
                while (it.hasNext()) {
                    Address mbr = (Address)it.next();
                    if (GossipClient.this.log.isTraceEnabled()) {
                        GossipClient.this.log.trace((Object)("registering " + group + " : " + mbr));
                    }
                    GossipClient.this.register(group, mbr);
                    ++num_items;
                }
            }
            if (GossipClient.this.log.isTraceEnabled()) {
                GossipClient.this.log.trace((Object)("refresher task done. Registered " + num_items + " items"));
            }
        }
    }
}

