/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.monitor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;

public class ManageSnapshotServlet
extends HttpServlet {
    static final long serialVersionUID = 128303790912009915L;
    private static final Logger log = Logger.getLogger(ManageSnapshotServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void error(String msg, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("error", (Object)("Error: " + msg));
        req.getRequestDispatcher("/manageSnapshot.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doit(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectName monitorObjectName;
        String action = req.getParameter("action");
        if (action == null) {
            this.error("unknown action: ", req, resp);
            return;
        }
        action = action.trim();
        MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
        String attribute = null;
        try {
            monitorObjectName = new ObjectName(req.getParameter("monitorObjectName"));
            attribute = (String)mbeanServer.getAttribute(monitorObjectName, "ObservedAttribute");
        }
        catch (Exception ex) {
            this.error("Malformed Monitor ObjectName: " + req.getParameter("monitorObjectName"), req, resp);
            return;
        }
        if (action.equals("Start Snapshot")) {
            Object[] nullArgs = new Object[]{};
            String[] nullSig = new String[]{};
            try {
                mbeanServer.invoke(monitorObjectName, "startSnapshot", nullArgs, nullSig);
            }
            catch (Exception ex) {
                this.error("Problem invoking startSnapshot: " + ex.toString(), req, resp);
                return;
            }
            req.getRequestDispatcher("/manageSnapshot.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (action.equals("Stop Snapshot")) {
            Object[] nullArgs = new Object[]{};
            String[] nullSig = new String[]{};
            try {
                mbeanServer.invoke(monitorObjectName, "endSnapshot", nullArgs, nullSig);
            }
            catch (Exception ex) {
                this.error("Problem invoking endSnapshot: " + ex.toString(), req, resp);
                return;
            }
            req.getRequestDispatcher("/manageSnapshot.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (action.equals("Clear Dataset")) {
            Object[] nullArgs = new Object[]{};
            String[] nullSig = new String[]{};
            try {
                mbeanServer.invoke(monitorObjectName, "clearData", nullArgs, nullSig);
            }
            catch (Exception ex) {
                this.error("Problem invoking clearData: " + ex.toString(), req, resp);
                return;
            }
            req.setAttribute("error", (Object)"Dataset Cleared!");
            req.getRequestDispatcher("/manageSnapshot.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (action.equals("Remove Snapshot")) {
            try {
                log.debug("removing snapshot: " + monitorObjectName.toString());
                mbeanServer.unregisterMBean(monitorObjectName);
                req.getRequestDispatcher("/ServerInfo.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (Exception ex) {
                this.error("Failed to Remove Monitor: " + ex.toString(), req, resp);
            }
            return;
        }
        if (action.equals("Show Dataset")) {
            long start;
            ArrayList data = null;
            long end = 0L;
            try {
                data = (ArrayList)mbeanServer.getAttribute(monitorObjectName, "Data");
                start = (Long)mbeanServer.getAttribute(monitorObjectName, "StartTime");
                end = (Long)mbeanServer.getAttribute(monitorObjectName, "EndTime");
            }
            catch (Exception ex) {
                this.error("Problem invoking getData: " + ex.toString(), req, resp);
                return;
            }
            resp.setContentType("text/html");
            PrintWriter writer = resp.getWriter();
            writer.println("<html>");
            writer.println("<body>");
            writer.println("<b>Start Time:</b> " + start + "ms<br>");
            writer.println("<b>End Time:</b> " + end + "ms<br>");
            writer.println("<b>Total Time:</b> " + (end - start) + "ms<br>");
            writer.println("<br><table border=\"0\">");
            for (int i = 0; i < data.size(); ++i) {
                writer.println("<tr><td>" + data.get(i) + "</td></tr");
            }
            writer.println("</table></body></html>");
            return;
        }
        if (action.equals("Graph Dataset")) {
            ArrayList data = null;
            long end = 0L;
            try {
                data = (ArrayList)mbeanServer.getAttribute(monitorObjectName, "Data");
                long start = (Long)mbeanServer.getAttribute(monitorObjectName, "StartTime");
                end = (Long)mbeanServer.getAttribute(monitorObjectName, "EndTime");
            }
            catch (Exception ex) {
                this.error("Problem invoking getData: " + ex.toString(), req, resp);
                return;
            }
            XYSeries set = new XYSeries((Comparable)((Object)attribute), false, false);
            for (int i = 0; i < data.size(); ++i) {
                set.add(new Integer(i), (Number)data.get(i));
            }
            DefaultTableXYDataset dataset = new DefaultTableXYDataset(false);
            dataset.addSeries(set);
            JFreeChart chart = ChartFactory.createXYLineChart("JMX Attribute: " + attribute, "count", attribute, dataset, PlotOrientation.VERTICAL, true, true, false);
            resp.setContentType("image/png");
            ServletOutputStream out = resp.getOutputStream();
            ChartUtilities.writeChartAsPNG((OutputStream)out, chart, 400, 300);
            out.close();
            return;
        }
        this.error("Unknown Action", req, resp);
    }
}

