/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateEvent;
import org.jboss.portal.portlet.federation.FederatedPortletInvoker;
import org.jboss.portal.portlet.federation.FederatingPortletInvoker;
import org.jboss.portal.portlet.federation.impl.FederatedPortlet;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.InstanceContext;
import org.jboss.portal.portlet.state.AccessMode;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederatedPortletInvokerService
implements FederatedPortletInvoker {
    private String id;
    private PortletInvoker portletInvoker;
    private FederatingPortletInvoker federatingPortletInvoker;

    public FederatedPortletInvokerService(FederatingPortletInvoker federatingPortletInvoker, String id, PortletInvoker portletInvoker) {
        this.id = id;
        this.portletInvoker = portletInvoker;
        this.federatingPortletInvoker = federatingPortletInvoker;
    }

    @Override
    public PortletInvoker getPortletInvoker() {
        return this.portletInvoker;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public FederatingPortletInvoker getFederatingPortletInvoker() {
        return this.federatingPortletInvoker;
    }

    public Set<Portlet> getPortlets() throws PortletInvokerException {
        LinkedHashSet<Portlet> federatedPortlets = new LinkedHashSet<Portlet>();
        for (Portlet portlet : this.portletInvoker.getPortlets()) {
            FederatedPortlet federatedPortlet = new FederatedPortlet(this, this.reference(portlet.getContext()), portlet);
            federatedPortlets.add(federatedPortlet);
        }
        return federatedPortlets;
    }

    public Portlet getPortlet(PortletContext compoundPortletContext) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        Portlet portlet = this.portletInvoker.getPortlet(portletContext);
        return new FederatedPortlet(this, compoundPortletContext, portlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws InvocationException, PortletInvokerException {
        PortletContext compoundPortletContext = invocation.getTarget();
        PortletContext portletContext = this.dereference(compoundPortletContext);
        InstanceContext instanceContext = invocation.getInstanceContext();
        try {
            invocation.setTarget(portletContext);
            invocation.setInstanceContext((InstanceContext)new FederatedInstanceContext(instanceContext));
            PortletInvocationResponse portletInvocationResponse = this.portletInvoker.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            invocation.setTarget(compoundPortletContext);
            invocation.setInstanceContext(instanceContext);
        }
    }

    public PortletContext createClone(PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        PortletContext cloneContext = this.portletInvoker.createClone(portletContext);
        return this.reference(cloneContext);
    }

    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException("Null portlet id list not accepted");
        }
        if (portletContexts.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<PortletContext> dereferencedList = new ArrayList<PortletContext>(portletContexts);
        for (int i = 0; i < dereferencedList.size(); ++i) {
            PortletContext compoundPortletContext = (PortletContext)dereferencedList.get(i);
            PortletContext portletContext = this.dereference(compoundPortletContext);
            dereferencedList.set(i, portletContext);
        }
        List failures = this.portletInvoker.destroyClones(dereferencedList);
        for (int i = 0; i < failures.size(); ++i) {
            DestroyCloneFailure failure = (DestroyCloneFailure)failures.get(i);
            String cloneId = failure.getPortletId();
            failure = new DestroyCloneFailure(this.reference(cloneId));
            failures.set(i, failure);
        }
        return failures;
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext) throws PortletInvokerException {
        PortletContext portletId = this.dereference(compoundPortletContext);
        return this.portletInvoker.getProperties(portletId);
    }

    public PropertyMap getProperties(PortletContext compoundPortletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletContext portletId = this.dereference(compoundPortletContext);
        return this.portletInvoker.getProperties(portletId, keys);
    }

    public PortletContext setProperties(PortletContext compoundPortletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletContext portletContext = this.dereference(compoundPortletContext);
        portletContext = this.portletInvoker.setProperties(portletContext, changes);
        return this.reference(portletContext);
    }

    private PortletContext dereference(PortletContext compoundPortletContext) {
        String portletId = compoundPortletContext.getId().substring(this.id.length() + 1);
        return PortletContext.createPortletContext((String)portletId, (byte[])compoundPortletContext.getState());
    }

    private PortletContext reference(PortletContext portletContext) {
        String compoundPortletId = this.reference(portletContext.getId());
        return PortletContext.createPortletContext((String)compoundPortletId, (byte[])portletContext.getState());
    }

    private String reference(String portletId) {
        return this.id + "." + portletId;
    }

    private class FederatedInstanceContext
    implements InstanceContext {
        private InstanceContext ctx;

        public FederatedInstanceContext(InstanceContext ctx) {
            this.ctx = ctx;
        }

        public String getId() {
            return this.ctx.getId();
        }

        public AccessMode getAccessMode() {
            return this.ctx.getAccessMode();
        }

        public void onStateEvent(StateEvent event) {
            this.ctx.onStateEvent(new StateEvent(FederatedPortletInvokerService.this.reference(event.getPortletContext()), event.getType()));
        }
    }
}

