/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javassist.bytecode.ClassFile;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.annotation.IgnoreDependencyImpl;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.ClusteredImpl;
import org.jboss.annotation.ejb.ConsumerImpl;
import org.jboss.annotation.ejb.CurrentMessageImpl;
import org.jboss.annotation.ejb.DefaultActivationSpecs;
import org.jboss.annotation.ejb.DefaultActivationSpecsImpl;
import org.jboss.annotation.ejb.DeliveryMode;
import org.jboss.annotation.ejb.Depends;
import org.jboss.annotation.ejb.DependsImpl;
import org.jboss.annotation.ejb.ExcludeClassInterceptorsImpl;
import org.jboss.annotation.ejb.ExcludeDefaultInterceptorsImpl;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.LocalBindingImpl;
import org.jboss.annotation.ejb.LocalHomeBinding;
import org.jboss.annotation.ejb.LocalHomeBindingImpl;
import org.jboss.annotation.ejb.LocalHomeImpl;
import org.jboss.annotation.ejb.Management;
import org.jboss.annotation.ejb.ManagementImpl;
import org.jboss.annotation.ejb.MessagePropertiesImpl;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.PoolClassImpl;
import org.jboss.annotation.ejb.Producers;
import org.jboss.annotation.ejb.RemoteBindingImpl;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.RemoteBindingsImpl;
import org.jboss.annotation.ejb.RemoteHomeBinding;
import org.jboss.annotation.ejb.RemoteHomeBindingImpl;
import org.jboss.annotation.ejb.RemoteHomeImpl;
import org.jboss.annotation.ejb.ResourceAdapter;
import org.jboss.annotation.ejb.ResourceAdapterImpl;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.annotation.ejb.SerializedConcurrentAccessImpl;
import org.jboss.annotation.ejb.ServiceImpl;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.annotation.ejb.TransactionTimeoutImpl;
import org.jboss.annotation.ejb.cache.Cache;
import org.jboss.annotation.ejb.cache.CacheImpl;
import org.jboss.annotation.ejb.cache.simple.CacheConfigImpl;
import org.jboss.annotation.ejb.cache.simple.PersistenceManager;
import org.jboss.annotation.ejb.cache.simple.PersistenceManagerImpl;
import org.jboss.annotation.internal.DefaultInterceptorMarker;
import org.jboss.annotation.internal.DefaultInterceptorMarkerImpl;
import org.jboss.annotation.security.RunAsPrincipalImpl;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.annotation.security.SecurityDomainImpl;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.ejb.ActivationConfigPropertyImpl;
import org.jboss.ejb.AroundInvokeImpl;
import org.jboss.ejb.DeclareRolesImpl;
import org.jboss.ejb.DenyAllImpl;
import org.jboss.ejb.InitImpl;
import org.jboss.ejb.InterceptorsImpl;
import org.jboss.ejb.LocalImpl;
import org.jboss.ejb.MessageDrivenImpl;
import org.jboss.ejb.PermitAllImpl;
import org.jboss.ejb.PostActivateImpl;
import org.jboss.ejb.PostConstructImpl;
import org.jboss.ejb.PreDestroyImpl;
import org.jboss.ejb.PrePassivateImpl;
import org.jboss.ejb.RemoteImpl;
import org.jboss.ejb.RemoveImpl;
import org.jboss.ejb.ResourceImpl;
import org.jboss.ejb.RolesAllowedImpl;
import org.jboss.ejb.RunAsImpl;
import org.jboss.ejb.StatelessImpl;
import org.jboss.ejb.TransactionAttributeImpl;
import org.jboss.ejb.TransactionManagementImpl;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3AnnotationHandler;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.cache.simple.SimpleStatefulCache;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.mdb.ProducerImpl;
import org.jboss.ejb3.mdb.ProducersImpl;
import org.jboss.ejb3.metamodel.ActivationConfig;
import org.jboss.ejb3.metamodel.AssemblyDescriptor;
import org.jboss.ejb3.metamodel.CacheConfig;
import org.jboss.ejb3.metamodel.ClusterConfig;
import org.jboss.ejb3.metamodel.Consumer;
import org.jboss.ejb3.metamodel.ContainerTransaction;
import org.jboss.ejb3.metamodel.CurrentMessage;
import org.jboss.ejb3.metamodel.EjbJarDD;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.metamodel.EnterpriseBeans;
import org.jboss.ejb3.metamodel.ExcludeList;
import org.jboss.ejb3.metamodel.InitMethod;
import org.jboss.ejb3.metamodel.InterceptorBinding;
import org.jboss.ejb3.metamodel.MessageDestination;
import org.jboss.ejb3.metamodel.MessageDrivenBean;
import org.jboss.ejb3.metamodel.MessageDrivenDestination;
import org.jboss.ejb3.metamodel.MessageProperties;
import org.jboss.ejb3.metamodel.Method;
import org.jboss.ejb3.metamodel.MethodAttributes;
import org.jboss.ejb3.metamodel.MethodPermission;
import org.jboss.ejb3.metamodel.PoolConfig;
import org.jboss.ejb3.metamodel.Producer;
import org.jboss.ejb3.metamodel.RemoteBinding;
import org.jboss.ejb3.metamodel.RemoveMethod;
import org.jboss.ejb3.metamodel.SecurityIdentity;
import org.jboss.ejb3.metamodel.Service;
import org.jboss.ejb3.metamodel.SessionEnterpriseBean;
import org.jboss.ejb3.metamodel.Webservices;
import org.jboss.ejb3.metamodel.XmlAnnotation;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.InjectionTarget;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.NameValuePair;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.metamodel.descriptor.RunAs;
import org.jboss.metamodel.descriptor.SecurityRole;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.annotation.WebContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3DescriptorHandler
extends Ejb3AnnotationHandler {
    private static final Logger log = Logger.getLogger(Ejb3DescriptorHandler.class);
    protected EjbJarDD dd;
    protected List<EnterpriseBean> ejbs = new ArrayList<EnterpriseBean>();

    public Ejb3DescriptorHandler(Ejb3Deployment deployment, ClassFile cf, EjbJarDD dd) {
        super(deployment, cf);
        this.dd = dd;
    }

    public Ejb3DescriptorHandler(Ejb3Deployment deployment, EjbJarDD dd) {
        super(deployment);
        this.dd = dd;
    }

    @Override
    public boolean isEjb() {
        if (super.isEjb()) {
            return true;
        }
        EnterpriseBeans enterpriseBeans = this.dd.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return false;
        }
        return enterpriseBeans.findEjbsByClass(this.cf.getName()).size() > 0;
    }

    @Override
    protected void populateBaseInfo() throws Exception {
        if (this.cf != null) {
            super.populateBaseInfo();
        }
        EnterpriseBeans enterpriseBeans = this.dd.getEnterpriseBeans() != null ? this.dd.getEnterpriseBeans() : new EnterpriseBeans();
        List<EnterpriseBean> ejbsByClass = this.cf == null ? enterpriseBeans.findEjbs() : enterpriseBeans.findEjbsByClass(this.cf.getName());
        for (int i = 0; i < this.ejbNames.size(); ++i) {
            String ejbNameFromAnnotation = (String)this.ejbNames.get(i);
            EnterpriseBean enterpriseBean = enterpriseBeans.findEjbByEjbName(ejbNameFromAnnotation);
            this.ejbs.add(enterpriseBean);
            int j = 0;
            while (j < ejbsByClass.size()) {
                EnterpriseBean ejbByClass = ejbsByClass.get(j);
                if (ejbByClass.getEjbName().equals(ejbNameFromAnnotation)) {
                    ejbsByClass.remove(j);
                    continue;
                }
                ++j;
            }
        }
        for (EnterpriseBean enterpriseBean : ejbsByClass) {
            String ejbName = enterpriseBean.getEjbName();
            this.ejbs.add(enterpriseBean);
            this.ejbNames.add(ejbName);
            this.ejbType = this.getEjbType(enterpriseBean);
        }
    }

    protected Ejb3AnnotationHandler.EJB_TYPE getEjbType(EnterpriseBean enterpriseBean) {
        if (enterpriseBean.isSessionBean()) {
            if (((SessionEnterpriseBean)enterpriseBean).isStateless()) {
                return Ejb3AnnotationHandler.EJB_TYPE.STATELESS;
            }
            return Ejb3AnnotationHandler.EJB_TYPE.STATEFUL;
        }
        if (enterpriseBean.isEntityBean()) {
            return Ejb3AnnotationHandler.EJB_TYPE.ENTITY;
        }
        if (enterpriseBean.isMessageDrivenBean()) {
            return Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN;
        }
        if (enterpriseBean.isService()) {
            return Ejb3AnnotationHandler.EJB_TYPE.SERVICE;
        }
        return Ejb3AnnotationHandler.EJB_TYPE.CONSUMER;
    }

    public List getContainers(Ejb3Deployment deployment, Map<String, Container> preexistingContainers) throws Exception {
        ArrayList<EJBContainer> containers = new ArrayList<EJBContainer>();
        EnterpriseBeans enterpriseBeans = this.dd.getEnterpriseBeans() != null ? this.dd.getEnterpriseBeans() : new EnterpriseBeans();
        Collection<EnterpriseBean> allXmlEjbs = enterpriseBeans.getEnterpriseBeans();
        this.ejbNames = new ArrayList();
        for (EnterpriseBean ejb : allXmlEjbs) {
            String ejbName = ejb.getEjbName();
            if (preexistingContainers.get(ejbName) != null) continue;
            this.ejbNames.add(ejbName);
            this.ejbs.add(ejb);
        }
        for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ++ejbIndex) {
            EJBContainer container;
            String ejbName = (String)this.ejbNames.get(ejbIndex);
            EnterpriseBean enterpriseBean = this.ejbs.get(ejbIndex);
            this.ejbType = this.getEjbType(enterpriseBean);
            this.className = enterpriseBean.getEjbClass();
            if (this.className == null) {
                log.warn((Object)("Descriptor based bean has no ejb-class defined: " + ejbName));
                continue;
            }
            this.ejbClass = this.di.getClassLoader().loadClass(this.className);
            if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATELESS) {
                container = this.getStatelessContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATEFUL) {
                container = this.getStatefulContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN) {
                container = this.getMDB(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.SERVICE) {
                container = this.getServiceContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.CONSUMER) {
                container = this.getConsumerContainer(ejbIndex);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            }
            log.debug((Object)("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + (Object)((Object)this.ejbType)));
        }
        return containers;
    }

    @Override
    protected StatefulContainer getStatefulContainer(int ejbIndex) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        EnterpriseBean enterpriseBean = this.ejbs.get(ejbIndex);
        StatefulContainer container = super.getStatefulContainer(ejbIndex);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        this.addInterfaces(container, enterpriseBean);
        this.addDescriptorAnnotations(container, enterpriseBean, ejbName, true);
        return container;
    }

    private void addHomeAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws Exception {
        RemoteHomeImpl annotation;
        if (enterpriseBean.getHome() != null) {
            annotation = new RemoteHomeImpl(this.di.getClassLoader().loadClass(enterpriseBean.getHome()));
            this.addClassAnnotation(container, annotation.annotationType(), annotation);
        }
        if (enterpriseBean.getLocalHome() != null) {
            annotation = new LocalHomeImpl(this.di.getClassLoader().loadClass(enterpriseBean.getLocalHome()));
            this.addClassAnnotation(container, annotation.annotationType(), annotation);
        }
    }

    @Override
    protected EJBContainer getStatelessContainer(int ejbIndex) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        EnterpriseBean enterpriseBean = this.ejbs.get(ejbIndex);
        EJBContainer container = super.getStatelessContainer(ejbIndex);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        StatelessImpl annotation = new StatelessImpl(ejbName);
        if (enterpriseBean != null && !this.isAnnotatedBean()) {
            this.addClassAnnotation(container, Stateless.class, annotation);
        }
        this.addInterfaces(container, enterpriseBean);
        this.addDescriptorAnnotations(container, enterpriseBean, ejbName);
        return container;
    }

    @Override
    protected ServiceContainer getServiceContainer(int ejbIndex) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        Service service = (Service)this.ejbs.get(ejbIndex);
        ServiceContainer container = super.getServiceContainer(ejbIndex);
        ServiceImpl annotation = new ServiceImpl((org.jboss.annotation.ejb.Service)container.resolveAnnotation(org.jboss.annotation.ejb.Service.class));
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        if (service != null && !this.isAnnotatedBean()) {
            if (service.getObjectName() != null) {
                annotation.setObjectName(service.getObjectName());
            }
            if (service.getEjbName() != null) {
                annotation.setName(service.getEjbName());
            }
            if (service.getXMBean() != null) {
                annotation.setXMBean(service.getXMBean());
            }
            this.addClassAnnotation(container, org.jboss.annotation.ejb.Service.class, annotation);
        }
        this.addInterfaces(container, service);
        this.addDescriptorAnnotations(container, service, ejbName);
        this.addServiceAnnotations(container, service);
        return container;
    }

    @Override
    protected ConsumerContainer getConsumerContainer(int ejbIndex) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        Consumer consumer = (Consumer)this.ejbs.get(ejbIndex);
        ConsumerContainer container = super.getConsumerContainer(ejbIndex);
        ConsumerImpl annotation = new ConsumerImpl((org.jboss.annotation.ejb.Consumer)container.resolveAnnotation(org.jboss.annotation.ejb.Consumer.class));
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        if (consumer != null && !this.isAnnotatedBean()) {
            ActivationConfigPropertyImpl property;
            if (consumer.getDestination() != null) {
                property = new ActivationConfigPropertyImpl("destination", consumer.getDestination());
                annotation.addActivationConfig((ActivationConfigProperty)property);
            }
            if (consumer.getDestinationType() != null) {
                property = new ActivationConfigPropertyImpl("destinationType", consumer.getDestinationType());
                annotation.addActivationConfig((ActivationConfigProperty)property);
            }
            this.addClassAnnotation(container, org.jboss.annotation.ejb.Consumer.class, annotation);
        }
        this.addInterfaces(container, consumer);
        this.addDescriptorAnnotations(container, consumer, ejbName);
        this.addConsumerAnnotations(container, consumer);
        return container;
    }

    @Override
    protected String getMDBDomainName(int ejbIndex) {
        return this.defaultMDBDomain;
    }

    @Override
    protected MDB getMDB(int ejbIndex) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        EnterpriseBean enterpriseBean = this.ejbs.get(ejbIndex);
        MDB container = super.getMDB(ejbIndex);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        this.addMDBAnnotations(container, ejbName, enterpriseBean);
        this.addInterfaces(container, enterpriseBean);
        this.addDescriptorAnnotations(container, enterpriseBean, ejbName);
        return container;
    }

    @Override
    protected String getAspectDomain(int ejbIndex, String defaultDomain) {
        String aopDomainName;
        EnterpriseBean enterpriseBean = this.ejbs.get(ejbIndex);
        if (enterpriseBean != null && (aopDomainName = enterpriseBean.getAopDomainName()) != null) {
            log.debug((Object)("Found aop-domain-name element for annotation " + aopDomainName + " for ejbName " + enterpriseBean.getEjbName()));
            return aopDomainName;
        }
        return super.getAspectDomain(ejbIndex, defaultDomain);
    }

    protected boolean isAnnotatedBean() {
        return super.isEjb() || super.isJBossBeanType();
    }

    private boolean isStateful(EnterpriseBean enterpriseBean) {
        return this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATEFUL;
    }

    private void addMDBAnnotations(MDB container, String ejbName, EnterpriseBean enterpriseBean) {
        if (enterpriseBean != null) {
            ActivationConfig activationConfig;
            MessageDrivenBean mdb = (MessageDrivenBean)enterpriseBean;
            ArrayList<ActivationConfigPropertyImpl> properties = new ArrayList<ActivationConfigPropertyImpl>();
            if (mdb.getAcknowledgeMode() != null) {
                properties.add(new ActivationConfigPropertyImpl("acknowledgeMode", mdb.getAcknowledgeMode()));
            }
            if (mdb.getMessageDrivenDestination() != null) {
                MessageDrivenDestination destination = mdb.getMessageDrivenDestination();
                if (destination.getDestinationType() != null) {
                    properties.add(new ActivationConfigPropertyImpl("destinationType", destination.getDestinationType()));
                }
                if (destination.getSubscriptionDurability() != null) {
                    String durable = "false";
                    if (destination.getSubscriptionDurability().equals("Durable")) {
                        durable = "true";
                    }
                    properties.add(new ActivationConfigPropertyImpl("subscriptionDurability", durable));
                    if (destination.getSubscriptionDurability().equals("Durable")) {
                        properties.add(new ActivationConfigPropertyImpl("subscriptionName", "subscriptionName"));
                    }
                }
            }
            if (mdb.getResourceAdaptorName() != null) {
                ResourceAdapterImpl adapter = new ResourceAdapterImpl(mdb.getResourceAdaptorName());
                this.addClassAnnotation(container, ResourceAdapter.class, adapter);
            }
            if ((activationConfig = mdb.getActivationConfig()) != null) {
                for (Object o : activationConfig.getActivationConfigProperties()) {
                    NameValuePair property = (NameValuePair)o;
                    properties.add(new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
                }
            }
            if (mdb.getDestinationJndiName() != null) {
                properties.add(new ActivationConfigPropertyImpl("destination", mdb.getDestinationJndiName()));
            }
            if (mdb.getMdbUser() != null) {
                properties.add(new ActivationConfigPropertyImpl("user", mdb.getMdbUser()));
            }
            if (mdb.getMdbPassword() != null) {
                properties.add(new ActivationConfigPropertyImpl("password", mdb.getMdbPassword()));
            }
            if (mdb.getMdbSubscriptionId() != null) {
                properties.add(new ActivationConfigPropertyImpl("subscriptionName", mdb.getMdbSubscriptionId()));
            }
            ActivationConfigProperty[] propsArray = new ActivationConfigPropertyImpl[properties.size()];
            properties.toArray(propsArray);
            MessageDrivenImpl annotation = new MessageDrivenImpl(ejbName, propsArray);
            if (mdb.getMessagingType() != null) {
                try {
                    annotation.setMessageListenerInterface(container.getClassloader().loadClass(mdb.getMessagingType()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.isAnnotatedBean()) {
                annotation.merge(this.ejbClass.getAnnotation(MessageDriven.class));
            }
            this.addClassAnnotation(container, MessageDriven.class, annotation);
            this.addDefaultActivationConfig(container, mdb);
        }
    }

    private void addDefaultActivationConfig(MDB container, MessageDrivenBean mdb) {
        ActivationConfig defaultActivationConfig = mdb.getDefaultActivationConfig();
        if (defaultActivationConfig != null) {
            DefaultActivationSpecsImpl activationAnnotation = new DefaultActivationSpecsImpl();
            for (Object o : defaultActivationConfig.getActivationConfigProperties()) {
                NameValuePair property = (NameValuePair)o;
                activationAnnotation.addActivationConfigProperty((ActivationConfigProperty)new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
            }
            DefaultActivationSpecs existingAnnotation = this.ejbClass.getAnnotation(DefaultActivationSpecs.class);
            if (existingAnnotation != null) {
                activationAnnotation.merge(existingAnnotation);
            }
            this.addClassAnnotation(container, DefaultActivationSpecs.class, activationAnnotation);
        }
    }

    private void addInterfaces(EJBContainer container, EnterpriseBean enterpriseBean) throws ClassNotFoundException {
        if (enterpriseBean != null) {
            Class[] intfs;
            String classname;
            String token;
            StringTokenizer classes;
            String local = enterpriseBean.getLocal();
            String remote = enterpriseBean.getRemote();
            if (remote != null) {
                classes = new StringTokenizer(remote, ",");
                ArrayList remoteClasses = new ArrayList();
                while (classes.hasMoreTokens()) {
                    token = classes.nextToken();
                    classname = token.trim();
                    remoteClasses.add(this.di.getClassLoader().loadClass(classname));
                }
                intfs = new Class[remoteClasses.size()];
                intfs = remoteClasses.toArray(intfs);
                this.addClassAnnotation(container, Remote.class, new RemoteImpl(intfs));
            }
            if (local != null) {
                classes = new StringTokenizer(local, ",");
                ArrayList localClasses = new ArrayList();
                while (classes.hasMoreTokens()) {
                    token = classes.nextToken();
                    classname = token.trim();
                    localClasses.add(this.di.getClassLoader().loadClass(classname));
                }
                intfs = new Class[localClasses.size()];
                intfs = localClasses.toArray(intfs);
                this.addClassAnnotation(container, Local.class, new LocalImpl(intfs));
            }
        }
    }

    private void addDescriptorAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) throws Exception {
        this.addDescriptorAnnotations(container, enterpriseBean, ejbName, false);
    }

    private void addDescriptorAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName, boolean isStateful) throws Exception {
        container.setXml(enterpriseBean);
        this.addTransactionAnnotations(container, enterpriseBean, ejbName);
        this.addAssemblyAnnotations(container, enterpriseBean, ejbName);
        this.addSecurityAnnotations(container, enterpriseBean, ejbName);
        this.addEjbAnnotations(container, enterpriseBean);
        this.addEjb21Annotations(container, isStateful);
        this.addWebServiceAnnotations(container, enterpriseBean, ejbName);
    }

    private void addWebServiceAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) {
        Webservices webservices;
        if (this.dd.getWebservices() != null && (webservices = this.dd.getWebservices()).getContextRoot() != null) {
            WebContextImpl webContextImpl = new WebContextImpl();
            webContextImpl.setContextRoot(webservices.getContextRoot());
            this.addClassAnnotation(container, WebContext.class, webContextImpl);
        }
    }

    private void addEjb21Annotations(EJBContainer container, boolean isStateful) throws Exception {
        Class<?>[] interfaces;
        for (Class<?> beanInterface : interfaces = this.ejbClass.getInterfaces()) {
            Class annotationClass;
            Object annotation;
            if (!beanInterface.equals(SessionBean.class)) continue;
            Method method = new Method();
            method.setEjbName(container.getEjbName());
            if (this.hasMethod(this.ejbClass, "ejbCreate")) {
                annotation = isStateful ? new InitImpl() : new PostConstructImpl();
                annotationClass = annotation.annotationType();
                method.setMethodName("ejbCreate");
                this.addAnnotations(annotationClass, annotation, container, method);
            }
            annotation = new PostActivateImpl();
            annotationClass = PostActivate.class;
            method.setMethodName("ejbActivate");
            this.addAnnotations(annotationClass, annotation, container, method);
            annotation = new PrePassivateImpl();
            annotationClass = PrePassivate.class;
            method.setMethodName("ejbPassivate");
            this.addAnnotations(annotationClass, annotation, container, method);
            annotation = new PreDestroyImpl();
            annotationClass = PreDestroy.class;
            method.setMethodName("ejbRemove");
            this.addAnnotations(annotationClass, annotation, container, method);
            annotation = new ResourceImpl();
            annotationClass = Resource.class;
            method.setMethodName("setSessionContext");
            this.addAnnotations(annotationClass, annotation, container, method);
        }
    }

    private void addAssemblyAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) throws Exception {
        AssemblyDescriptor assembly = this.dd.getAssemblyDescriptor();
        if (assembly != null) {
            this.addExcludeAnnotations(container, assembly.getExcludeList(), ejbName);
            this.addInterceptorBindingAnnotations(container, enterpriseBean, ejbName);
        }
        if (enterpriseBean instanceof SessionEnterpriseBean) {
            this.addInitAnnotations(container, ((SessionEnterpriseBean)enterpriseBean).getInitMethods(), ejbName);
            this.addRemoveAnnotations(container, ((SessionEnterpriseBean)enterpriseBean).getRemoveMethods(), ejbName);
        }
    }

    private void addExcludeAnnotations(EJBContainer container, ExcludeList list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null) {
            for (Object o : list.getMethods()) {
                Method method = (Method)o;
                if (!method.getEjbName().equals(ejbName)) continue;
                DenyAllImpl annotation = new DenyAllImpl();
                this.addAnnotations(DenyAll.class, annotation, container, method);
            }
        }
    }

    private void addInitAnnotations(EJBContainer container, List<InitMethod> list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null) {
            for (InitMethod initMethod : list) {
                Method method = initMethod.getBeanMethod();
                InitImpl annotation = new InitImpl();
                this.addAnnotations(Init.class, annotation, container, method);
            }
        }
    }

    private void addRemoveAnnotations(EJBContainer container, List<RemoveMethod> list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null) {
            for (RemoveMethod removeMethod : list) {
                Method method = removeMethod.getBeanMethod();
                RemoveImpl annotation = new RemoveImpl(removeMethod.isRetainIfException());
                this.addAnnotations(Remove.class, annotation, container, method);
            }
        }
    }

    private void addSecurityAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        SecurityDomain annotation;
        SecurityDomainImpl annotation2;
        String securityDomain;
        AssemblyDescriptor assembly = this.dd.getAssemblyDescriptor();
        if (assembly != null) {
            List securityRoles = assembly.getSecurityRoles();
            if (securityRoles.size() > 0) {
                ArrayList<String> roleList = new ArrayList<String>();
                for (Object securityRole : securityRoles) {
                    SecurityRole role = (SecurityRole)securityRole;
                    roleList.add(role.getRoleName());
                }
                DeclareRolesImpl annotation3 = new DeclareRolesImpl(roleList.toArray(new String[roleList.size()]));
                this.addClassAnnotation(container, DeclareRoles.class, annotation3);
            }
            List methodPermissions = assembly.getMethodPermissions();
            for (Object methodPermission : methodPermissions) {
                MethodPermission permission = (MethodPermission)methodPermission;
                for (Method method : permission.getMethods()) {
                    Object annotation4;
                    if (!method.getEjbName().equals(ejbName)) continue;
                    if (permission.isUnchecked()) {
                        annotation4 = new PermitAllImpl();
                        this.addAnnotations(PermitAll.class, annotation4, container, method);
                        continue;
                    }
                    annotation4 = new RolesAllowedImpl();
                    for (Object o : permission.getRoleNames()) {
                        String roleName = (String)o;
                        ((RolesAllowedImpl)annotation4).addValue(roleName);
                    }
                    this.addAnnotations(RolesAllowed.class, annotation4, container, method);
                }
            }
        }
        if (enterpriseBean != null && enterpriseBean.getSecurityDomain() != null) {
            securityDomain = enterpriseBean.getSecurityDomain();
            annotation2 = new SecurityDomainImpl(securityDomain);
            if (this.dd.getUnauthenticatedPrincipal() != null) {
                annotation2.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            }
            this.addClassAnnotation(container, annotation2.annotationType(), annotation2);
        } else if (this.dd.getSecurityDomain() != null) {
            securityDomain = this.dd.getSecurityDomain();
            annotation2 = new SecurityDomainImpl(securityDomain);
            if (this.dd.getUnauthenticatedPrincipal() != null) {
                annotation2.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            }
            this.addClassAnnotation(container, annotation2.annotationType(), annotation2);
        } else if (this.dd.getUnauthenticatedPrincipal() != null && (annotation = this.ejbClass.getAnnotation(SecurityDomain.class)) != null) {
            SecurityDomainImpl override = new SecurityDomainImpl(annotation.value());
            override.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            this.addClassAnnotation(container, override.annotationType(), override);
        }
    }

    private void addTransactionAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        AssemblyDescriptor descriptor;
        if (enterpriseBean != null) {
            MethodAttributes attributes;
            if (enterpriseBean.getTransactionManagementType() != null) {
                TransactionManagementImpl annotation = new TransactionManagementImpl();
                annotation.setValue(enterpriseBean.getTransactionManagementType());
                this.addClassAnnotation(container, TransactionManagement.class, annotation);
            }
            if ((attributes = enterpriseBean.getMethodAttributes()) != null) {
                for (Method method : attributes.getMethods()) {
                    if (method.getTransactionTimeout() == null) continue;
                    TransactionTimeoutImpl timeoutAnnotation = new TransactionTimeoutImpl(Integer.parseInt(method.getTransactionTimeout()));
                    this.addAnnotations(TransactionTimeout.class, timeoutAnnotation, container, method);
                }
            }
        }
        if ((descriptor = this.dd.getAssemblyDescriptor()) != null) {
            for (ContainerTransaction transaction : descriptor.getContainerTransactions()) {
                if (!transaction.getMethod().getEjbName().equals(ejbName)) continue;
                String transAttribute = transaction.getTransAttribute();
                TransactionAttributeImpl annotation = new TransactionAttributeImpl();
                if (transAttribute.equals("Mandatory")) {
                    annotation.setType(TransactionAttributeType.MANDATORY);
                } else if (transAttribute.equals("Required")) {
                    annotation.setType(TransactionAttributeType.REQUIRED);
                } else if (transAttribute.equals("RequiresNew")) {
                    annotation.setType(TransactionAttributeType.REQUIRES_NEW);
                } else if (transAttribute.equals("Supports")) {
                    annotation.setType(TransactionAttributeType.SUPPORTS);
                } else if (transAttribute.equals("NotSupported")) {
                    annotation.setType(TransactionAttributeType.NOT_SUPPORTED);
                } else if (transAttribute.equals("Never")) {
                    annotation.setType(TransactionAttributeType.NEVER);
                }
                this.addAnnotations(TransactionAttribute.class, annotation, container, transaction.getMethod());
            }
        }
    }

    private void addInterceptorBindingAnnotations(EJBContainer container, EnterpriseBean enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        boolean definesInterceptors = false;
        List<InterceptorBinding> interceptorBindings = this.dd.getAssemblyDescriptor().getInterceptorBindings();
        for (InterceptorBinding binding : interceptorBindings) {
            if (!binding.getEjbName().equals(ejbName)) continue;
            if (binding.getMethodName() == null || binding.getMethodName().trim().length() == 0) {
                this.addClassLevelInterceptorBindingAnnotations(container, binding);
                definesInterceptors = true;
                continue;
            }
            definesInterceptors = this.addMethodLevelInterceptorBindingAnnotations(container, binding);
        }
        if (!definesInterceptors && this.di.getInterceptorInfoRepository().hasDefaultInterceptors()) {
            this.addClassAnnotation(container, DefaultInterceptorMarker.class, new DefaultInterceptorMarkerImpl());
        }
    }

    private void addClassLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBinding binding) throws ClassNotFoundException {
        Interceptors interceptors = (Interceptors)container.resolveAnnotation(Interceptors.class);
        InterceptorsImpl impl = InterceptorsImpl.getImpl(interceptors);
        for (String name : binding.getInterceptorClasses()) {
            Class<?> clazz = this.di.getClassLoader().loadClass(name);
            impl.addValue(clazz);
        }
        this.addClassAnnotation(container, impl.annotationType(), impl);
        boolean exclude = binding.getExcludeDefaultInterceptors();
        if (exclude && container.resolveAnnotation(ExcludeDefaultInterceptors.class) == null) {
            this.addClassAnnotation(container, ExcludeDefaultInterceptors.class, new ExcludeDefaultInterceptorsImpl());
        }
    }

    private boolean addMethodLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBinding binding) throws ClassNotFoundException {
        boolean addedAnnotations = false;
        for (java.lang.reflect.Method method : container.getBeanClass().getMethods()) {
            boolean excludeClass;
            boolean matches = false;
            if (method.getName().equals(binding.getMethodName())) {
                if (binding.getMethodParams() == null) {
                    matches = true;
                } else {
                    List bindingParams;
                    Class<?>[] methodParams = method.getParameterTypes();
                    if (methodParams.length == (bindingParams = binding.getMethodParams()).size()) {
                        matches = true;
                        int i = 0;
                        for (String paramName : bindingParams) {
                            String methodParamName;
                            if (paramName.equals(methodParamName = InterceptorInfoRepository.simpleType(methodParams[i++]))) continue;
                            matches = false;
                            break;
                        }
                    }
                }
            }
            if (!matches) continue;
            Interceptors interceptors = (Interceptors)container.resolveAnnotation(method, Interceptors.class);
            InterceptorsImpl impl = InterceptorsImpl.getImpl(interceptors);
            for (String name : binding.getInterceptorClasses()) {
                Class<?> clazz = this.di.getClassLoader().loadClass(name);
                impl.addValue(clazz);
            }
            log.debug((Object)("adding " + Interceptors.class.getName() + " method annotation to " + this.ejbClass.getName() + "." + method.getName() + "(" + Ejb3DescriptorHandler.getParameters(method) + ")"));
            container.getAnnotations().addAnnotation((Member)method, Interceptors.class, (Object)impl);
            boolean excludeDefault = binding.getExcludeDefaultInterceptors();
            if (excludeDefault && container.resolveAnnotation(method, ExcludeDefaultInterceptors.class) == null) {
                log.debug((Object)("adding " + ExcludeDefaultInterceptors.class.getName() + " method annotation to " + this.ejbClass.getName() + "." + method.getName() + "(" + Ejb3DescriptorHandler.getParameters(method) + ")"));
                container.getAnnotations().addAnnotation((Member)method, ExcludeDefaultInterceptors.class, (Object)new ExcludeDefaultInterceptorsImpl());
            }
            if ((excludeClass = binding.getExcludeClassInterceptors()) && container.resolveAnnotation(method, ExcludeClassInterceptors.class) == null) {
                log.debug((Object)("adding " + ExcludeClassInterceptors.class.getName() + " method annotation to " + this.ejbClass.getName() + "." + method.getName() + "(" + Ejb3DescriptorHandler.getParameters(method) + ")"));
                container.getAnnotations().addAnnotation((Member)method, ExcludeClassInterceptors.class, (Object)new ExcludeClassInterceptorsImpl());
            }
            matches = false;
            addedAnnotations = true;
        }
        return addedAnnotations;
    }

    private void addEjbAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws Exception {
        if (enterpriseBean != null) {
            this.addHomeAnnotations(container, enterpriseBean);
            this.addJndiAnnotations(container, enterpriseBean);
            this.addInterceptorMethodAnnotations(container, enterpriseBean);
            this.handleResourceRefs(container, enterpriseBean.getResourceRefs());
            this.addMessageDestinationAnnotations(container, enterpriseBean.getMessageDestinationRefs());
            this.addSecurityIdentityAnnotation(container, enterpriseBean.getSecurityIdentity());
            this.addDependencies(container, enterpriseBean);
            this.addPoolAnnotations(container, enterpriseBean);
            this.addXmlAnnotations(container, enterpriseBean);
            if (enterpriseBean instanceof SessionEnterpriseBean) {
                this.addConcurrentAnnotations(container, (SessionEnterpriseBean)enterpriseBean);
                this.addClusterAnnotations(container, (SessionEnterpriseBean)enterpriseBean);
                this.addCacheAnnotations(container, (SessionEnterpriseBean)enterpriseBean);
            }
        }
    }

    private void addConcurrentAnnotations(EJBContainer container, SessionEnterpriseBean enterpriseBean) throws Exception {
        if (enterpriseBean.getConcurrent() != null) {
            boolean concurrent = Boolean.getBoolean(enterpriseBean.getConcurrent());
            if (concurrent) {
                SerializedConcurrentAccessImpl annotation = new SerializedConcurrentAccessImpl();
                this.addClassAnnotation(container, SerializedConcurrentAccess.class, annotation);
            } else {
                container.getAnnotations().disableAnnotation(SerializedConcurrentAccess.class.getName());
            }
        }
    }

    private void addPoolAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws Exception {
        if (enterpriseBean.getPoolConfig() != null) {
            PoolConfig config = enterpriseBean.getPoolConfig();
            PoolClassImpl poolAnnotation = new PoolClassImpl();
            if (config.getPoolClass() != null) {
                poolAnnotation.setValue(this.di.getClassLoader().loadClass(config.getPoolClass()));
            }
            if (config.getMaxSize() != null) {
                poolAnnotation.setMaxSize(Integer.parseInt(config.getMaxSize()));
            }
            if (config.getTimeout() != null) {
                poolAnnotation.setTimeout(Long.parseLong(config.getTimeout()));
            }
            this.addClassAnnotation(container, PoolClass.class, poolAnnotation);
        }
    }

    private void addXmlAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws Exception {
        for (XmlAnnotation xmlAnnotation : enterpriseBean.getXmlAnnotations()) {
            Class<?> annotationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationClass());
            Class<?> annotationImplementationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationImplementationClass());
            Object annotation = annotationImplementationClass.newInstance();
            for (NameValuePair property : xmlAnnotation.getProperties()) {
                Field field = annotationImplementationClass.getDeclaredField(property.getName());
                this.setAnnotationPropertyField(field, annotation, property.getValue());
            }
            if (xmlAnnotation.getInjectionTarget() == null) {
                this.addClassAnnotation(container, annotationClass, annotation);
                continue;
            }
            Method method = new Method();
            method.setMethodName(xmlAnnotation.getInjectionTarget().getTargetName());
            this.addAnnotations(annotationClass, annotation, container, method);
        }
    }

    protected void setAnnotationPropertyField(Field field, Object annotation, String value) throws Exception {
        if (field.getType() == String.class) {
            field.set(annotation, value);
        } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
            field.setLong(annotation, Long.parseLong(value));
        } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
            field.setInt(annotation, Integer.parseInt(value));
        } else if (field.getType() == Class.class) {
            field.set(annotation, this.di.getClassLoader().loadClass(value));
        } else if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
            field.setBoolean(annotation, Boolean.parseBoolean(value));
        } else {
            throw new IllegalArgumentException("unsupported field type " + field.getType() + " on field " + field);
        }
    }

    private void addCacheAnnotations(EJBContainer container, SessionEnterpriseBean enterpriseBean) throws Exception {
        if (enterpriseBean.getCacheConfig() != null) {
            org.jboss.annotation.ejb.cache.simple.CacheConfig existingConfig;
            org.jboss.annotation.ejb.cache.tree.CacheConfigImpl configAnnotation;
            CacheConfig config = enterpriseBean.getCacheConfig();
            if (config.getCacheClass() != null) {
                Class<?> cacheClass = this.di.getClassLoader().loadClass(config.getCacheClass());
                CacheImpl cacheAnnotation = new CacheImpl(cacheClass);
                this.addClassAnnotation(container, Cache.class, cacheAnnotation);
                if (cacheClass == SimpleStatefulCache.class && !this.ejbClass.isAnnotationPresent(PersistenceManager.class)) {
                    PersistenceManagerImpl persistenceAnnotation = new PersistenceManagerImpl();
                    if (config.getPersistenceManager() != null) {
                        persistenceAnnotation.setValue(this.di.getClassLoader().loadClass(config.getPersistenceManager()));
                    }
                    this.addClassAnnotation(container, PersistenceManager.class, persistenceAnnotation);
                }
            }
            if (config.getName() != null) {
                configAnnotation = new org.jboss.annotation.ejb.cache.tree.CacheConfigImpl();
                configAnnotation.setName(config.getName());
                if (config.getMaxSize() != null) {
                    configAnnotation.setMaxSize(Integer.parseInt(config.getMaxSize()));
                }
                if (config.getIdleTimeoutSeconds() != null) {
                    configAnnotation.setIdleTimeoutSeconds(Long.parseLong(config.getIdleTimeoutSeconds()));
                }
                if (config.getReplicationIsPassivation() != null) {
                    configAnnotation.setReplicationIsPassivation(Boolean.parseBoolean(config.getReplicationIsPassivation()));
                }
                if (config.getRemoveTimeoutSeconds() != null) {
                    configAnnotation.setRemovalTimeoutSeconds(Long.parseLong(config.getRemoveTimeoutSeconds()));
                }
                if ((existingConfig = this.ejbClass.getAnnotation(org.jboss.annotation.ejb.cache.tree.CacheConfig.class)) != null) {
                    configAnnotation.merge((org.jboss.annotation.ejb.cache.tree.CacheConfig)existingConfig);
                }
                this.addClassAnnotation(container, org.jboss.annotation.ejb.cache.tree.CacheConfig.class, configAnnotation);
            } else {
                configAnnotation = new CacheConfigImpl();
                if (config.getMaxSize() != null) {
                    configAnnotation.setMaxSize(Integer.parseInt(config.getMaxSize()));
                }
                if (config.getIdleTimeoutSeconds() != null) {
                    configAnnotation.setIdleTimeoutSeconds(Long.parseLong(config.getIdleTimeoutSeconds()));
                }
                if (config.getRemoveTimeoutSeconds() != null) {
                    configAnnotation.setRemovalTimeoutSeconds(Long.parseLong(config.getRemoveTimeoutSeconds()));
                }
                if ((existingConfig = this.ejbClass.getAnnotation(org.jboss.annotation.ejb.cache.simple.CacheConfig.class)) != null) {
                    configAnnotation.merge(existingConfig);
                }
                this.addClassAnnotation(container, org.jboss.annotation.ejb.cache.simple.CacheConfig.class, configAnnotation);
            }
        }
    }

    private void addClusterAnnotations(EJBContainer container, SessionEnterpriseBean enterpriseBean) throws Exception {
        ClusterConfig config;
        ClusteredImpl clusteredAnnotation = null;
        if (enterpriseBean.getClustered() != null) {
            Clustered existingAnnotation = this.ejbClass.getAnnotation(Clustered.class);
            boolean clustered = Boolean.parseBoolean(enterpriseBean.getClustered());
            if (!clustered) {
                if (existingAnnotation != null) {
                    container.getAnnotations().disableAnnotation(Clustered.class.getName());
                }
                return;
            }
            if (existingAnnotation == null) {
                clusteredAnnotation = new ClusteredImpl();
            }
        }
        if ((config = enterpriseBean.getClusterConfig()) != null) {
            if (clusteredAnnotation == null) {
                clusteredAnnotation = new ClusteredImpl();
            }
            if (config.getLoadBalancePolicy() != null) {
                Class<?> policy = this.di.getClassLoader().loadClass(config.getLoadBalancePolicy());
                clusteredAnnotation.setLoadBalancePolicy(policy);
            }
            if (config.getPartition() != null) {
                clusteredAnnotation.setPartition(config.getPartition());
            }
        }
        if (clusteredAnnotation != null) {
            this.addClassAnnotation(container, Clustered.class, clusteredAnnotation);
        }
    }

    private void addDependencies(EJBContainer container, EnterpriseBean enterpriseBean) throws Exception {
        if (enterpriseBean.getDependencies().size() > 0) {
            DependsImpl annotation = new DependsImpl();
            Iterator<String> dependencies = enterpriseBean.getDependencies().iterator();
            while (dependencies.hasNext()) {
                annotation.addDependency(dependencies.next());
            }
            this.addClassAnnotation(container, Depends.class, annotation);
        }
        if (enterpriseBean.getIgnoreDependencies().size() > 0) {
            for (InjectionTarget ignore : enterpriseBean.getIgnoreDependencies()) {
                IgnoreDependencyImpl annotation = new IgnoreDependencyImpl();
                Method method = new Method();
                method.setMethodName(ignore.getTargetName());
                this.addAnnotations(IgnoreDependency.class, annotation, container, method);
            }
        }
    }

    private void addServiceAnnotations(EJBContainer container, EnterpriseBean ejb) throws ClassNotFoundException {
        Service service = (Service)ejb;
        if (service == null) {
            return;
        }
        String management = service.getManagement();
        if (management != null) {
            ManagementImpl annotation = new ManagementImpl(this.di.getClassLoader().loadClass(management));
            this.addClassAnnotation(container, Management.class, annotation);
        }
    }

    private void addConsumerAnnotations(EJBContainer container, EnterpriseBean ejb) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        MessageProperties properties;
        CurrentMessage currentMessage;
        Consumer consumer = (Consumer)ejb;
        if (consumer == null) {
            return;
        }
        if (consumer.getProducers().size() > 0 || consumer.getLocalProducers().size() > 0) {
            ProducerImpl annotation;
            ProducersImpl producersAnnotation = new ProducersImpl();
            for (Producer producer : consumer.getProducers()) {
                annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
                if (producer.getConnectionFactory() != null) {
                    annotation.setConnectionFactory(producer.getConnectionFactory());
                }
                producersAnnotation.addProducer(annotation);
            }
            for (Producer producer : consumer.getLocalProducers()) {
                annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
                if (producer.getConnectionFactory() != null) {
                    annotation.setConnectionFactory(producer.getConnectionFactory());
                }
                producersAnnotation.addProducer(annotation);
            }
            this.addClassAnnotation(container, Producers.class, producersAnnotation);
        }
        if ((currentMessage = consumer.getCurrentMessage()) != null) {
            List methods = currentMessage.getMethods();
            CurrentMessageImpl annotation = new CurrentMessageImpl();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                this.addAnnotations(org.jboss.annotation.ejb.CurrentMessage.class, annotation, container, method);
            }
        }
        if ((properties = consumer.getMessageProperties()) != null) {
            String interfac;
            List methods = properties.getMethods();
            MessagePropertiesImpl annotation = new MessagePropertiesImpl();
            String delivery = properties.getDelivery();
            if (delivery != null && delivery.equals("Persistent")) {
                annotation.setDelivery(DeliveryMode.PERSISTENT);
            } else {
                annotation.setDelivery(DeliveryMode.NON_PERSISTENT);
            }
            String priority = properties.getPriority();
            if (priority != null) {
                annotation.setDelivery(DeliveryMode.PERSISTENT);
            }
            if ((interfac = properties.getClassName()) != null) {
                Class<?> clazz = this.di.getClassLoader().loadClass(interfac);
                annotation.setInterface(clazz);
            }
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                this.addAnnotations(org.jboss.annotation.ejb.MessageProperties.class, annotation, container, method);
            }
        }
    }

    private void addJndiAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws ClassNotFoundException {
        this.addLocalJndiAnnotations(container, enterpriseBean);
        this.addRemoteJndiAnnotations(container, enterpriseBean);
    }

    private void addLocalJndiAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws ClassNotFoundException {
        String localHomeJndiName;
        String localJndiName = enterpriseBean.getLocalJndiName();
        if (localJndiName != null) {
            LocalBindingImpl localBinding = new LocalBindingImpl(localJndiName);
            this.addClassAnnotation(container, LocalBinding.class, localBinding);
        }
        if ((localHomeJndiName = enterpriseBean.getLocalHomeJndiName()) != null) {
            LocalHomeBindingImpl localHomeBinding = new LocalHomeBindingImpl(localHomeJndiName);
            this.addClassAnnotation(container, LocalHomeBinding.class, localHomeBinding);
        }
    }

    private void addRemoteJndiAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws ClassNotFoundException {
        List<RemoteBinding> bindingsList;
        String homeJndiName = enterpriseBean.getHomeJndiName();
        if (homeJndiName != null) {
            RemoteHomeBindingImpl homeBinding = new RemoteHomeBindingImpl(homeJndiName);
            this.addClassAnnotation(container, RemoteHomeBinding.class, homeBinding);
        }
        if ((bindingsList = enterpriseBean.getRemoteBindings()).size() == 0) {
            this.addSimpleJndiAnnotations(container, enterpriseBean);
            return;
        }
        AnnotationRepository annotations = container.getAnnotations();
        annotations.disableAnnotation(org.jboss.annotation.ejb.RemoteBinding.class.getName());
        ArrayList<RemoteBindingImpl> bindingAnnotationsList = new ArrayList<RemoteBindingImpl>();
        for (RemoteBinding binding : bindingsList) {
            RemoteBindingImpl bindingAnnotation = new RemoteBindingImpl();
            if (binding.getJndiName() != null) {
                bindingAnnotation.setJndiBinding(binding.getJndiName());
            }
            if (binding.getClientBindUrl() != null) {
                bindingAnnotation.setBindUrl(binding.getClientBindUrl());
            }
            if (binding.getInterceptorStack() != null) {
                bindingAnnotation.setStack(binding.getInterceptorStack());
            }
            if (binding.getProxyFactory() != null) {
                bindingAnnotation.setFactory(this.di.getClassLoader().loadClass(binding.getProxyFactory()));
            }
            bindingAnnotationsList.add(bindingAnnotation);
        }
        RemoteBindingsImpl bindingsAnnotation = new RemoteBindingsImpl(bindingAnnotationsList);
        this.addClassAnnotation(container, RemoteBindings.class, bindingsAnnotation);
    }

    private void addSimpleJndiAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) throws ClassNotFoundException {
        RemoteBindingImpl remoteBinding = null;
        String jndiName = enterpriseBean.getJndiName();
        if (jndiName != null) {
            remoteBinding = new RemoteBindingImpl();
            remoteBinding.setJndiBinding(jndiName);
            this.addClassAnnotation(container, org.jboss.annotation.ejb.RemoteBinding.class, remoteBinding);
        }
        if (remoteBinding != null) {
            org.jboss.annotation.ejb.RemoteBinding existingBinding = this.ejbClass.getAnnotation(org.jboss.annotation.ejb.RemoteBinding.class);
            if (existingBinding != null) {
                remoteBinding.merge(existingBinding);
            }
            this.addClassAnnotation(container, org.jboss.annotation.ejb.RemoteBinding.class, remoteBinding);
        }
    }

    private void handleResourceRefs(EJBContainer container, Collection<ResourceRef> resourceRefList) {
        for (ResourceRef ref : resourceRefList) {
            if (ref.getResourceName() == null) continue;
            ref.setJndiName(this.dd.resolveResourceManager(ref.getResourceName()));
            ref.setMappedName(this.dd.resolveResourceManager(ref.getResourceName()));
        }
    }

    private void addMessageDestinationAnnotations(EJBContainer container, Collection destinationRefList) {
        for (MessageDestinationRef ref : destinationRefList) {
            MessageDestination destination;
            AssemblyDescriptor descriptor;
            if (ref.getMappedName() != null && !ref.getMappedName().equals("") || (descriptor = this.dd.getAssemblyDescriptor()) == null || (destination = descriptor.findMessageDestination(ref.getMessageDestinationLink())) == null) continue;
            ref.setMappedName(destination.getJndiName());
        }
    }

    private void addInterceptorMethodAnnotations(EJBContainer container, EnterpriseBean enterpriseBean) {
        if (enterpriseBean instanceof SessionEnterpriseBean) {
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((SessionEnterpriseBean)enterpriseBean).getAroundInvoke(), AroundInvoke.class, "around-invoke-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((SessionEnterpriseBean)enterpriseBean).getPostConstruct(), PostConstruct.class, "post-construct-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((SessionEnterpriseBean)enterpriseBean).getPostActivate(), PostActivate.class, "post-activate-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((SessionEnterpriseBean)enterpriseBean).getPrePassivate(), PrePassivate.class, "pre-passivate-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((SessionEnterpriseBean)enterpriseBean).getPreDestroy(), PreDestroy.class, "pre-destroy-method");
        } else if (enterpriseBean instanceof MessageDrivenBean) {
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((MessageDrivenBean)enterpriseBean).getAroundInvoke(), AroundInvoke.class, "around-invoke-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((MessageDrivenBean)enterpriseBean).getPostConstruct(), PostConstruct.class, "post-construct-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, ((MessageDrivenBean)enterpriseBean).getPreDestroy(), PreDestroy.class, "pre-destroy-method");
        }
    }

    private void addInterceptorMethodAnnotation(EJBContainer container, EnterpriseBean enterpriseBean, Method method, Class ann, String xmlName) {
        if (method == null) {
            return;
        }
        java.lang.reflect.Method found = null;
        for (java.lang.reflect.Method rm : container.getBeanClass().getDeclaredMethods()) {
            if (!rm.getName().equals(method.getMethodName())) continue;
            if (ann == AroundInvoke.class) {
                if (!InterceptorInfoRepository.checkValidBusinessSignature(rm)) continue;
                found = rm;
                break;
            }
            if (!InterceptorInfoRepository.checkValidBeanLifecycleSignature(rm)) continue;
            found = rm;
            break;
        }
        if (found == null) {
            log.warn((Object)("No method found within " + container.getBeanClassName() + " with name " + method.getMethodName() + " with the right signature for " + xmlName + "was found"));
            return;
        }
        if (container.resolveAnnotation(found, ann) == null) {
            log.debug((Object)("adding " + ann.getName() + " method annotation to " + this.ejbClass.getName() + "." + found.getName()));
            container.getAnnotations().addAnnotation((Member)found, ann, this.getInterceptorImpl(ann));
        }
    }

    private Object getInterceptorImpl(Class ann) {
        if (ann == AroundInvoke.class) {
            return new AroundInvokeImpl();
        }
        if (ann == PostConstruct.class) {
            return new PostConstructImpl();
        }
        if (ann == PostActivate.class) {
            return new PostActivateImpl();
        }
        if (ann == PrePassivate.class) {
            return new PrePassivateImpl();
        }
        if (ann == PreDestroy.class) {
            return new PreDestroyImpl();
        }
        return null;
    }

    private void addSecurityIdentityAnnotation(EJBContainer container, SecurityIdentity identity) {
        RunAs runAs;
        if (identity != null && !identity.isUseCallerIdentity() && (runAs = identity.getRunAs()) != null) {
            RunAsImpl annotation = new RunAsImpl(runAs.getRoleName());
            this.addClassAnnotation(container, annotation.annotationType(), annotation);
            String runAsPrincipal = identity.getRunAsPrincipal();
            if (runAsPrincipal != null) {
                RunAsPrincipalImpl principalAnnotation = new RunAsPrincipalImpl(runAs.getRoleName());
                this.addClassAnnotation(container, principalAnnotation.annotationType(), principalAnnotation);
            }
        }
    }

    protected void overrideAnnotations(EJBContainer container, Member m, String annotation, Object value) {
        AnnotationRepository annotations = container.getAnnotations();
        if (value instanceof DenyAll) {
            annotations.disableAnnotation(m, PermitAll.class.getName());
            annotations.disableAnnotation(m, RolesAllowed.class.getName());
        } else if (value instanceof PermitAll) {
            annotations.disableAnnotation(m, DenyAll.class.getName());
            annotations.disableAnnotation(m, RolesAllowed.class.getName());
        } else if (value instanceof RolesAllowed) {
            annotations.disableAnnotation(m, PermitAll.class.getName());
            annotations.disableAnnotation(m, DenyAll.class.getName());
        }
    }

    private void addClassAnnotation(EJBContainer container, Class annotationClass, Object annotation) {
        log.debug((Object)("adding class annotation " + annotationClass.getName() + " to " + this.ejbClass.getName() + " " + annotation));
        container.getAnnotations().addClassAnnotation(annotationClass, annotation);
    }

    private void addAnnotations(Class annotationClass, Object annotation, EJBContainer container, Method method) {
        String methodName = method.getMethodName();
        try {
            AnnotationRepository annotations = container.getAnnotations();
            if (methodName.equals("*")) {
                log.debug((Object)("adding " + annotationClass.getName() + " annotation to " + this.ejbClass.getName() + "." + methodName));
                for (java.lang.reflect.Method declaredMethod : this.ejbClass.getDeclaredMethods()) {
                    annotations.addAnnotation((Member)declaredMethod, annotationClass, annotation);
                    this.overrideAnnotations(container, declaredMethod, annotationClass.getName(), annotation);
                }
            } else {
                List params = method.getMethodParams();
                if (params == null) {
                    Field member;
                    int methodIndex;
                    java.lang.reflect.Method[] methods = this.ejbClass.getMethods();
                    boolean foundMethod = false;
                    for (methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                        if (!methods[methodIndex].getName().equals(methodName)) continue;
                        log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + this.ejbClass.getName() + "." + methodName));
                        annotations.addAnnotation((Member)methods[methodIndex], annotationClass, annotation);
                        this.overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
                        foundMethod = true;
                    }
                    if (!foundMethod) {
                        methods = this.ejbClass.getDeclaredMethods();
                        for (methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                            if (!methods[methodIndex].getName().equals(methodName)) continue;
                            log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + this.ejbClass.getName() + "." + methodName));
                            annotations.addAnnotation((Member)methods[methodIndex], annotationClass, annotation);
                            this.overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
                            foundMethod = true;
                        }
                    }
                    if (!foundMethod && (member = this.ejbClass.getDeclaredField(methodName)) != null) {
                        log.debug((Object)("adding " + annotationClass.getName() + " field annotation to " + this.ejbClass.getName() + "." + methodName));
                        annotations.addAnnotation((Member)member, annotationClass, annotation);
                        this.overrideAnnotations(container, member, annotationClass.getName(), annotation);
                    }
                } else {
                    Class[] methodSignature = new Class[params.size()];
                    Iterator paramIterator = params.iterator();
                    int paramIndex = 0;
                    while (paramIterator.hasNext()) {
                        String param = (String)paramIterator.next();
                        Class<Comparable<Boolean>> paramClass = null;
                        paramClass = param.equals("boolean") ? Boolean.TYPE : (param.equals("int") ? Integer.TYPE : (param.equals("long") ? Long.TYPE : (param.equals("short") ? Short.TYPE : (param.equals("byte") ? Byte.TYPE : (param.equals("char") ? Character.TYPE : this.di.getClassLoader().loadClass(param))))));
                        methodSignature[paramIndex++] = paramClass;
                    }
                    java.lang.reflect.Method member = this.ejbClass.getMethod(methodName, methodSignature);
                    log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + this.ejbClass.getName() + "." + methodName));
                    annotations.addAnnotation((Member)member, annotationClass, annotation);
                    this.overrideAnnotations(container, member, annotationClass.getName(), annotation);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create annotation from method/field " + method.getMethodName() + " for EJB " + container.getEjbName(), e);
        }
    }

    private static String getParameters(java.lang.reflect.Method m) {
        if (m.getParameterTypes().length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Class<?> param : m.getParameterTypes()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(InterceptorInfoRepository.simpleType(param));
        }
        return sb.toString();
    }

    private boolean hasMethod(Class<?> cls, String methodName) {
        assert (cls != null) : "cls is null";
        assert (methodName != null) : "methodName is null";
        for (java.lang.reflect.Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return true;
        }
        if (cls.getSuperclass() != null) {
            return this.hasMethod(cls.getSuperclass(), methodName);
        }
        return false;
    }
}

