/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.theming;

import java.util.LinkedHashSet;
import java.util.Set;
import org.osivia.portal.api.theming.UserPage;

public class UserPagesGroup {
    private String icon;
    private String displayName;
    private UserPage rootPage;
    private final String name;
    private final Set<UserPage> pages;
    private final Set<UserPage> displayedPages;
    private final Set<UserPage> hiddenPages;

    public UserPagesGroup(String name) {
        this.name = name;
        this.pages = new LinkedHashSet<UserPage>();
        this.displayedPages = new LinkedHashSet<UserPage>();
        this.hiddenPages = new LinkedHashSet<UserPage>();
    }

    public void add(UserPage page, boolean displayed) {
        this.pages.add(page);
        if (displayed) {
            this.displayedPages.add(page);
        } else {
            this.hiddenPages.add(page);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserPagesGroup other = (UserPagesGroup)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserPagesGroup [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserPage getRootPage() {
        return this.rootPage;
    }

    public void setRootPage(UserPage rootPage) {
        this.rootPage = rootPage;
    }

    public String getName() {
        return this.name;
    }

    public Set<UserPage> getPages() {
        return this.pages;
    }

    public Set<UserPage> getDisplayedPages() {
        return this.displayedPages;
    }

    public Set<UserPage> getHiddenPages() {
        return this.hiddenPages;
    }
}

