/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.netvibes;

import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.UUIDGenerator;
import org.jboss.portal.widget.Widget;
import org.jboss.portal.widget.netvibes.NetvibesPreferenceInfo;
import org.jboss.portal.widget.netvibes.NetvibesPreferencesInfo;
import org.jboss.portal.widget.netvibes.NetvibesWidgetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetvibesWidget
implements Widget {
    private static final UUIDGenerator generator = new UUIDGenerator();
    private final URL url;
    private final String id;
    private String defaultHeight = "250";
    private final NetvibesWidgetInfo widgetInfo;

    public NetvibesWidget(URL url, NetvibesWidgetInfo widgetInfo) {
        this.url = url;
        this.id = url.toString();
        this.widgetInfo = widgetInfo;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = String.valueOf(defaultHeight);
    }

    public LocalizedString getDescription() {
        return this.widgetInfo.getMetaData().getDescription();
    }

    public String getId() {
        return this.id;
    }

    public LocalizedString getTitle() {
        return this.widgetInfo.getTitle();
    }

    public NetvibesWidgetInfo getWidgetInfo() {
        return this.widgetInfo;
    }

    public String render(Map<String, String> parameters) {
        return this.render(parameters, null);
    }

    public String render(Map<String, String> parameters, Locale locale) {
        NetvibesWidgetInfo widgetInfo = this.getWidgetInfo();
        if (widgetInfo != null) {
            String id = generator.generateKey();
            String tempHeight = null;
            StringBuffer frameUrl = new StringBuffer();
            frameUrl.append("http://www.netvibes.com/api/uwa/frame/uwa_generic.php?id=" + id);
            frameUrl.append("&amp;moduleUrl=" + FastURLEncoder.getUTF8Instance().encode(this.url.toString()));
            if (parameters.size() > 0) {
                NetvibesPreferencesInfo preferences = widgetInfo.getPreferencesInfo();
                Iterator<String> i = preferences.getPreferences().iterator();
                while (i.hasNext()) {
                    NetvibesPreferenceInfo info = preferences.getPreference(i.next());
                    String name = info.getName();
                    String value = parameters.get(name);
                    if (value == null) {
                        value = info.getDefaultValue();
                    }
                    if (value == null) continue;
                    int index = name.toLowerCase().indexOf("height");
                    if (index != -1) {
                        tempHeight = value;
                    }
                    if (value.equals(info.getDefaultValue())) continue;
                    frameUrl.append("&amp;" + FastURLEncoder.getUTF8Instance().encode(name) + "=" + FastURLEncoder.getUTF8Instance().encode(value));
                }
            }
            String actualHeight = tempHeight != null ? String.valueOf(Integer.valueOf(tempHeight) + 50) : this.defaultHeight;
            StringBuffer output = new StringBuffer();
            output.append("<iframe id=\"frame_" + id + "\" name=\"frame_" + id + "\" frameborder=\"0\" width=\"100%\" height=\"" + actualHeight + "\" ");
            output.append("src=\"");
            output.append(frameUrl);
            output.append("\"></iframe>");
            return output.toString();
        }
        return "Error";
    }
}

