/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import java.util.Collections;
import java.util.Set;
import org.jboss.portal.core.admin.ui.InstanceManagerBean;
import org.jboss.portal.core.admin.ui.PortletManagerBean;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.faces.gui.ManagedBean;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.spi.provider.DomainConfigurator;

public class CreateInstanceAction
extends ManagedBean {
    private String instanceId;
    private PortletManagerBean portletMgr;
    private InstanceManagerBean instanceMgr;
    private static final String MESSAGE_TARGET = "add_instance_form:instanceId";
    protected static final String INSTANCE_TYPE = "INSTANCE_TYPE";

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public PortletManagerBean getPortletManager() {
        return this.portletMgr;
    }

    public void setPortletManager(PortletManagerBean portletManager) {
        this.portletMgr = portletManager;
    }

    public InstanceManagerBean getInstanceManager() {
        return this.instanceMgr;
    }

    public void setInstanceManager(InstanceManagerBean instanceManager) {
        this.instanceMgr = instanceManager;
    }

    public String execute() {
        this.instanceId = this.checkNameValidity(this.instanceId, MESSAGE_TARGET);
        if (this.instanceId == null) {
            return null;
        }
        Portlet portlet = this.portletMgr.getSelectedPortlet();
        if (portlet == null) {
            this.beanContext.createTargetedErrorMessage(MESSAGE_TARGET, "NO_SELECTED_PORTLET_ERROR", new Object[0]);
            return null;
        }
        InstanceContainer container = this.instanceMgr.getInstanceContainer();
        try {
            InstanceDefinition instance = container.createDefinition(this.instanceId, portlet.getContext().getId());
            this.instanceMgr.setSelectedId(this.instanceId);
            DomainConfigurator configurator = this.instanceMgr.getDomainConfigurator();
            Set<RoleSecurityBinding> constraints = Collections.singleton(new RoleSecurityBinding("view", SecurityConstants.UNCHECKED_ROLE_NAME));
            configurator.setSecurityBindings(instance.getId(), constraints);
            this.instanceMgr.refresh();
            this.instanceMgr.setSelectedId(this.instanceId);
            this.instanceMgr.setSelectedPlugin("info");
            return "instances";
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred during instance creation.", (Throwable)e);
            this.beanContext.createErrorMessageFrom(MESSAGE_TARGET, e);
            return null;
        }
    }

    protected String getObjectTypeName() {
        return INSTANCE_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.instanceMgr.getInstanceContainer().getDefinition(objectName) != null;
    }
}

