/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalContainer;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.faces.gui.ManagedBean;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.spi.provider.DomainConfigurator;

public class PortalAction
extends ManagedBean {
    private PortalObjectManagerBean pomgr;
    private String portalName;
    private static final String MESSAGE_TARGET = "create-portal-form:name";
    protected static final String PORTAL_TYPE = "PORTAL_TYPE";

    public PortalObjectManagerBean getPortalObjectManager() {
        return this.pomgr;
    }

    public void setPortalObjectManager(PortalObjectManagerBean portalObjectManager) {
        this.pomgr = portalObjectManager;
    }

    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    public String getDefaultObjectName() {
        return this.pomgr.getSelectedObject().getDeclaredProperty("portal.defaultObjectName");
    }

    public void setDefaultObjectName(String defaultObjectName) {
        if (!ParameterValidation.isNullOrEmpty((String)defaultObjectName)) {
            this.pomgr.getSelectedObject().setDeclaredProperty("portal.defaultObjectName", defaultObjectName);
        } else {
            this.pomgr.getSelectedObject().setDeclaredProperty("portal.defaultObjectName", null);
        }
    }

    public void addPortal() {
        try {
            PortalContainer portalContainer = (PortalContainer)this.pomgr.getSelectedObject();
            this.portalName = this.checkNameValidity(this.portalName, MESSAGE_TARGET);
            if (this.portalName != null) {
                Portal portal = portalContainer.createPortal(this.portalName);
                DomainConfigurator configurator = this.pomgr.getDomainConfigurator();
                HashSet<String> actions = new HashSet<String>();
                actions.add("viewrecursive");
                actions.add("personalizerecursive");
                RoleSecurityBinding binding = new RoleSecurityBinding(actions, SecurityConstants.UNCHECKED_ROLE_NAME);
                Set<RoleSecurityBinding> constraints = Collections.singleton(binding);
                configurator.setSecurityBindings(portal.getId().toString(PortalObjectPath.CANONICAL_FORMAT), constraints);
                portal.setDeclaredProperty("layout.id", "generic");
                portal.setDeclaredProperty("theme.renderSetId", "divRenderer");
                portal.getSupportedWindowStates().add(WindowState.MAXIMIZED);
                portal.getSupportedWindowStates().add(WindowState.MINIMIZED);
                portal.getSupportedWindowStates().add(WindowState.NORMAL);
                portal.getSupportedModes().add(Mode.EDIT);
                portal.getSupportedModes().add(Mode.HELP);
                portal.getSupportedModes().add(Mode.VIEW);
                portal.getSupportedModes().add(Mode.ADMIN);
                Page page = portal.createPage("default");
                constraints = Collections.singleton(new RoleSecurityBinding("viewrecursive", SecurityConstants.UNCHECKED_ROLE_NAME));
                configurator.setSecurityBindings(page.getId().toString(PortalObjectPath.CANONICAL_FORMAT), constraints);
                portal.setDeclaredProperty("portal.defaultObjectName", page.getName());
            }
        }
        catch (Exception e) {
            this.beanContext.createErrorMessageFrom(MESSAGE_TARGET, e);
        }
    }

    protected String getObjectTypeName() {
        return PORTAL_TYPE;
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.pomgr.getSelectedObject().getChild(objectName) != null;
    }
}

