/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portlet.util;

import java.util.Map;

public class Parameters {
    private Map parameters;

    public Parameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        String[] value = (String[])this.parameters.get(name);
        return value == null ? null : value[0];
    }

    public String get(String key, String def) {
        String value = this.getParameter(key);
        if (value != null) {
            return value;
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.getParameter(key);
        if (value != null) {
            if ("true".equalsIgnoreCase(value.trim())) {
                return true;
            }
            if ("false".equalsIgnoreCase(value.trim())) {
                return false;
            }
            return def;
        }
        return def;
    }

    public Boolean getBooleanObject(String key, boolean def) {
        Boolean bool = this.getBooleanObject(key);
        return bool != null ? bool : new Boolean(def);
    }

    public Boolean getBooleanObject(String key) {
        String value = this.getParameter(key);
        if (value != null) {
            if ("true".equalsIgnoreCase(value.trim())) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value.trim())) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    public byte[] getByteArray(String key, byte[] def) {
        String value = this.getParameter(key);
        byte[] returnValue = def;
        if (value != null) {
            returnValue = value.getBytes();
            if (returnValue == null) {
                returnValue = def;
            }
            return returnValue;
        }
        return def;
    }

    public double getDouble(String key, double def) {
        String value = this.getParameter(key);
        double returnValue = def;
        if (value != null) {
            try {
                returnValue = Double.parseDouble(value);
                return returnValue;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public Double getDoubleObject(String key, double defaultValue) {
        Double value = this.getDoubleObject(key);
        return value != null ? value : new Double(defaultValue);
    }

    public Double getDoubleObject(String key) {
        try {
            String value = this.getParameter(key);
            return value != null ? new Double(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public float getFloat(String key, float def) {
        String value = this.getParameter(key);
        float returnValue = def;
        if (value != null) {
            try {
                returnValue = Float.parseFloat(value);
                return returnValue;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public Float getFloatObject(String key, float defaultValue) {
        Float value = this.getFloatObject(key);
        return value != null ? value : new Float(defaultValue);
    }

    public Float getFloatObject(String key) {
        try {
            String value = this.getParameter(key);
            return value != null ? new Float(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public short getShort(String key, short def) {
        String value = this.getParameter(key);
        short returnValue = def;
        if (value != null) {
            try {
                returnValue = Short.parseShort(value);
                return returnValue;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public Short getShortObject(String key, short defaultValue) {
        Short value = this.getShortObject(key);
        return value != null ? value : new Short(defaultValue);
    }

    public Short getShortObject(String key) {
        try {
            String value = this.getParameter(key);
            return value != null ? new Short(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getInt(String key, int def) {
        String value = this.getParameter(key);
        int returnValue = def;
        if (value != null) {
            try {
                returnValue = Integer.parseInt(value);
                return returnValue;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public Integer getIntObject(String key, int defaultValue) {
        Integer value = this.getIntObject(key);
        return value != null ? value : new Integer(defaultValue);
    }

    public Integer getIntObject(String key) {
        try {
            String value = this.getParameter(key);
            return value != null ? new Integer(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public long getLong(String key, long def) {
        String value = this.getParameter(key);
        long returnValue = def;
        if (value != null) {
            try {
                returnValue = Long.parseLong(value);
                return returnValue;
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public Long getLongObject(String key, long defaultValue) {
        Long value = this.getLongObject(key);
        return value != null ? value : new Long(defaultValue);
    }

    public Long getLongObject(String key) {
        try {
            String value = this.getParameter(key);
            return value != null ? new Long(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean getParameterExists(String param) {
        String result = this.getParameter(param);
        return result != null && result.length() != 0;
    }
}

