/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.loader;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.jboss.portal.faces.loader.FacesClassLoader;

public class FacesLoaderServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(FacesLoaderServlet.class);
    private final String servletContextListenerClassName = "org.apache.myfaces.webapp.StartupServletContextListener";
    private FacesClassLoader loader;
    private ServletContextListener listener;
    private Servlet servlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        try {
            ServletContext ctx = this.getServletConfig().getServletContext();
            ArrayList<URL> tmp = new ArrayList<URL>();
            File f = new File(ctx.getRealPath("/WEB-INF/lib2/"));
            File[] libs = f.listFiles();
            for (int i = 0; i < libs.length; ++i) {
                File lib = libs[i];
                URL libURL = lib.toURL();
                log.debug((Object)("Added " + libURL + " to faces class loader"));
                tmp.add(libURL);
            }
            URL[] urls = tmp.toArray(new URL[tmp.size()]);
            this.loader = new FacesClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new ServletException("Cannot find WEB-INF/lib2 directory to load libraries from", (Throwable)e);
        }
        if (this.loader != null) {
            this.getServletConfig().getServletContext().setAttribute("FACESCLASSLOADER", (Object)this.loader);
            ClassLoader containerLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            try {
                this.initMyFaces();
                this.initFacesServlet();
            }
            finally {
                Thread.currentThread().setContextClassLoader(containerLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.loader != null) {
            ClassLoader containerLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            try {
                this.destroyFacesServlet();
                this.destroyMyFaces();
            }
            finally {
                Thread.currentThread().setContextClassLoader(containerLoader);
            }
        }
    }

    private void initFacesServlet() {
        try {
            Class<?> facesServletClass = this.loader.loadClass("javax.faces.webapp.FacesServlet");
            this.servlet = (Servlet)facesServletClass.newInstance();
            this.servlet.init(this.getServletConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void destroyFacesServlet() {
        if (this.servlet != null) {
            this.servlet.destroy();
        }
    }

    private void initMyFaces() {
        try {
            Class<?> bridgeClass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.myfaces.webapp.StartupServletContextListener");
            log.debug((Object)("Obtain bridge bootstrap class " + bridgeClass.getName()));
            this.listener = (ServletContextListener)bridgeClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Bridge bootstrap not available org.apache.myfaces.webapp.StartupServletContextListener", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Bridge bootstrap not accessible org.apache.myfaces.webapp.StartupServletContextListener", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Bridge bootstrap not instantiable org.apache.myfaces.webapp.StartupServletContextListener", (Throwable)e);
        }
        if (this.listener != null) {
            log.debug((Object)"About to initialize the bridge bootstrap");
            ServletContextEvent event = new ServletContextEvent(this.getServletConfig().getServletContext());
            this.listener.contextInitialized(event);
        }
    }

    private void destroyMyFaces() {
        if (this.listener != null) {
            log.debug((Object)"About to destroy the bridge bootstrap");
            ServletContextEvent event = new ServletContextEvent(this.getServletConfig().getServletContext());
            this.listener.contextDestroyed(event);
        }
    }
}

