/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;

public class SSOIntraAuthenticationValve
extends ValveBase {
    private static final Logger log = Logger.getLogger(SSOIntraAuthenticationValve.class);
    private String authType = "FORM";

    public boolean authenticate(String login, String password) {
        try {
            InitialContext initialContext = new InitialContext();
            UserModule userModule = null;
            userModule = (UserModule)initialContext.lookup("java:/portal/UserModule");
            User user = userModule.findUserByUserName(login);
            if (user != null) {
                return user.validatePassword(password);
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
        }
        return false;
    }

    public byte[] displayLoginForm(String errorMsg) {
        StringBuffer sb = new StringBuffer();
        sb.append("<body style=\"font-family: Verdana,Arial,Helvetica,Sans-Serif,sans-serif;\"><html>");
        if (errorMsg != null) {
            sb.append("<span style=\"color: #FF0000;\">" + errorMsg + "</span>");
        }
        sb.append("<form method=\"post\" action=\"/portail/intra-admin/check\" name=\"loginform\" id=\"loginForm\" target=\"_parent\" style=\"margin:0;padding:0\">");
        sb.append("      <div class=\"form-field\">");
        sb.append("          <label for=\"j_username\">Identifiant");
        sb.append("          </label>");
        sb.append("          <input type=\"text\" style=\"width:155px;\" name=\"j_username\" id=\"j_username\" value=\"\" />");
        sb.append("      </div>");
        sb.append("   <div class=\"form-field\">");
        sb.append("          <label for=\"j_password\">Mot de passe");
        sb.append("         </label>");
        sb.append("          <input type=\"password\" style=\"width:155px;\" name=\"j_password\" id=\"j_password\" value=\"\" />");
        sb.append("      </div>");
        sb.append("      <br class=\"clear\"/>");
        sb.append("      <div class=\"button-container\">");
        sb.append("          <input type=\"submit\" name=\"login\" id=\"login-submit\"");
        sb.append("                 value=\"Se connecter\" class=\"login-button\"/>");
        sb.append("      </div>");
        sb.append("  </form>");
        sb.append("</html></body>");
        return String.valueOf(sb).getBytes();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Pattern expOrginial;
        Matcher mResrTest;
        String location;
        Request httpRequest = request;
        String host = request.getHeader("host");
        String uri = request.getDecodedRequestURI();
        if (StringUtils.indexOf((String)uri, (String)"/portail/intra-admin") == 0) {
            HttpSession session = httpRequest.getSession();
            if (session.getAttribute("intranet_user") == null) {
                session.setAttribute("edu.yale.its.tp.cas.client.filter.user", (Object)"SKIP_CAS");
                String userName = request.getParameter("j_username");
                String password = request.getParameter("j_password");
                if (userName != null && password != null) {
                    request.setAttribute("ssoEnabled", (Object)"true");
                    if (!this.authenticate(userName, password)) {
                        response.getOutputStream().write(this.displayLoginForm("Login/mot de passe incorrect"));
                        response.getOutputStream().flush();
                        return;
                    }
                    request.setAttribute("ssoSuccess", (Object)new Boolean(true));
                    Principal principal = ((Context)this.container).getRealm().authenticate(userName, (String)null);
                    if (principal != null) {
                        this.register(request, response, principal, this.authType, userName, null);
                        session.setAttribute("intranet_user", (Object)userName);
                        String redirect = "http://" + host + "/portail/auth/portal/admin/osivia-admin";
                        response.sendRedirect(redirect);
                        return;
                    }
                } else {
                    response.getOutputStream().write(this.displayLoginForm(null));
                    response.getOutputStream().flush();
                    return;
                }
            }
            String redirect = "http://" + host + "/portail/auth/portal/admin/osivia-admin";
            response.sendRedirect(redirect);
            return;
        }
        this.getNext().invoke(request, response);
        HttpSession session = httpRequest.getSession();
        if (session.getAttribute("intranet_user") != null && response.getStatus() == 302 && StringUtils.isNotEmpty((String)(location = response.getHeader("Location"))) && (mResrTest = (expOrginial = Pattern.compile("http://(([^/:]*)(:[0-9]*)?)?/portail/(.*)")).matcher(location)).matches() && mResrTest.groupCount() == 4) {
            for (int i = 0; i <= mResrTest.groupCount(); ++i) {
                location = "http://" + host + "/portail/" + mResrTest.group(4);
                response.setHeader("Location", location);
            }
        }
    }

    private void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }
}

