/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.portalobjects;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.osivia.portal.core.page.PageProperties;

public class PortalObjectUtils {
    public static final PortalObjectId getPageId(ControllerContext controllerContext) {
        PortalObjectId pageId = null;
        if (controllerContext != null) {
            pageId = (PortalObjectId)controllerContext.getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, (Object)"osivia.currentPageId");
        }
        return pageId;
    }

    public static final Page getPage(ControllerContext controllerContext) {
        PortalObjectId pageId;
        Page page = null;
        if (controllerContext != null && (pageId = PortalObjectUtils.getPageId(controllerContext)) != null) {
            PortalObjectContainer portalObjectContainer = controllerContext.getController().getPortalObjectContainer();
            page = (Page)portalObjectContainer.getObject(pageId, Page.class);
        }
        return page;
    }

    public static final Portal getPortal(ControllerContext controllerContext) {
        PortalObjectContainer portalObjectContainer;
        PortalObject portalObject;
        Portal portal = null;
        String portalName = PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        if (controllerContext != null && portalName != null && (portalObject = (portalObjectContainer = controllerContext.getController().getPortalObjectContainer()).getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT))) instanceof Portal) {
            portal = (Portal)portalObject;
        }
        return portal;
    }

    public static final Portal getPortal(PortalObject po) {
        Window window;
        Page page;
        Portal portal = null;
        if (po instanceof Portal) {
            portal = (Portal)po;
        } else if (po instanceof Page) {
            Page page2 = (Page)po;
            portal = page2.getPortal();
        } else if (po instanceof Window && (page = (window = (Window)po).getPage()) != null) {
            portal = page.getPortal();
        }
        return portal;
    }

    public static final boolean isAncestor(PortalObject po1, PortalObject po2) {
        if (po1 == null || po2 == null) {
            return false;
        }
        PortalObject parent = po2.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.equals(po1)) {
            return true;
        }
        return PortalObjectUtils.isAncestor(po1, parent);
    }

    public static final String getDisplayName(PortalObject po, Locale[] locales) {
        if (po == null) {
            return null;
        }
        if (locales == null) {
            return po.getName();
        }
        LocalizedString localizedString = po.getDisplayName();
        if (localizedString == null) {
            return po.getName();
        }
        Map displayNames = localizedString.getValues();
        if (displayNames == null) {
            return po.getName();
        }
        for (Locale locale : locales) {
            if (displayNames.containsKey(locale)) {
                LocalizedString.Value displayName = (LocalizedString.Value)displayNames.get(locale);
                return displayName.getString();
            }
            Locale languageLocale = new Locale(locale.getLanguage());
            if (displayNames.containsKey(languageLocale)) {
                LocalizedString.Value displayName = (LocalizedString.Value)displayNames.get(languageLocale);
                return displayName.getString();
            }
            for (Locale displayNameLocale : displayNames.keySet()) {
                if (!locale.getLanguage().equals(displayNameLocale.getLanguage())) continue;
                LocalizedString.Value displayName = (LocalizedString.Value)displayNames.get(displayNameLocale);
                return displayName.getString();
            }
        }
        return po.getName();
    }

    public static final String getDisplayName(PortalObject po, Enumeration<Locale> locales) {
        if (po == null) {
            return null;
        }
        if (locales == null) {
            return po.getName();
        }
        ArrayList<Locale> collection = Collections.list(locales);
        Locale[] array = collection.toArray(new Locale[collection.size()]);
        return PortalObjectUtils.getDisplayName(po, array);
    }

    public static final String getDisplayName(PortalObject po, Locale locale) {
        Locale[] locales = null;
        if (locale != null) {
            locales = new Locale[]{locale};
        }
        return PortalObjectUtils.getDisplayName(po, locales);
    }

    public static final boolean isTemplate(PortalObject po) {
        if (po == null) {
            return false;
        }
        PortalObject parent = po.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof Portal) {
            return "templates".equals(po.getName());
        }
        return PortalObjectUtils.isTemplate(parent);
    }

    public static final PortalObject getTemplatesRoot(PortalObject po) {
        if (po == null) {
            return null;
        }
        Portal portal = PortalObjectUtils.getPortal(po);
        if (portal == null) {
            return null;
        }
        PortalObject templatesRoot = portal.getChild("templates");
        if (templatesRoot == null) {
            try {
                portal.createPage("templates");
                templatesRoot = portal.getChild("templates");
            }
            catch (Exception e) {
                return null;
            }
        }
        return templatesRoot;
    }

    public static final boolean isSpaceSite(PortalObject po) {
        if (po == null) {
            return false;
        }
        Portal portal = PortalObjectUtils.getPortal(po);
        if (portal == null) {
            return false;
        }
        String portalType = portal.getProperty("osivia.portal.portalType");
        return StringUtils.equals((String)"space", (String)portalType);
    }

    public static boolean isJBossPortalAdministration(PortalObject po) {
        if (po == null) {
            return false;
        }
        Portal portal = PortalObjectUtils.getPortal(po);
        if (portal == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((String)"admin", (String)portal.getName());
    }

    public static String getHTMLSafeId(PortalObjectId id) {
        if (id == null) {
            return null;
        }
        String safestFormat = id.toString(PortalObjectPath.SAFEST_FORMAT);
        try {
            return URLEncoder.encode(safestFormat, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isPortalDefaultPage(PortalObject po) {
        PortalObject parent;
        Page page;
        Portal portal;
        if (po == null) {
            return false;
        }
        if (po instanceof Page && (portal = (page = (Page)po).getPortal()).equals(parent = page.getParent())) {
            String defaultPageName = portal.getDeclaredProperty("portal.defaultObjectName");
            return StringUtils.equals((String)defaultPageName, (String)page.getName());
        }
        return false;
    }

    public static Window getMaximizedWindow(ControllerContext controllerContext, Page page) {
        Window maximizedWindow = null;
        if (controllerContext != null && page != null) {
            Collection portalObjects = page.getChildren(8);
            for (PortalObject portalObject : portalObjects) {
                Window window = (Window)portalObject;
                NavigationalStateKey navigationalStateKey = new NavigationalStateKey(WindowNavigationalState.class, (Object)window.getId());
                WindowNavigationalState windowNavigationalState = (WindowNavigationalState)controllerContext.getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, (Object)navigationalStateKey);
                if (windowNavigationalState == null || !WindowState.MAXIMIZED.equals((Object)windowNavigationalState.getWindowState())) continue;
                maximizedWindow = window;
                break;
            }
        }
        return maximizedWindow;
    }
}

