/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.sso.josso;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.identity.sso.josso.JOSSOIdentityService;
import org.josso.auth.BindableCredentialStore;
import org.josso.auth.Credential;
import org.josso.auth.CredentialKey;
import org.josso.auth.CredentialProvider;
import org.josso.auth.exceptions.SSOAuthenticationException;
import org.josso.auth.scheme.AuthenticationScheme;
import org.josso.auth.scheme.PasswordCredential;
import org.josso.auth.scheme.UsernameCredential;
import org.josso.gateway.SSONameValuePair;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.BaseRole;
import org.josso.gateway.identity.service.BaseRoleImpl;
import org.josso.gateway.identity.service.BaseUser;
import org.josso.gateway.identity.service.BaseUserImpl;
import org.josso.gateway.identity.service.store.IdentityStore;
import org.josso.gateway.identity.service.store.SimpleUserKey;
import org.josso.gateway.identity.service.store.UserKey;

public class JOSSOIdentityStore
implements IdentityStore,
BindableCredentialStore {
    private static Logger log = Logger.getLogger(JOSSOIdentityStore.class);
    private AuthenticationScheme authenticationScheme = null;
    private JOSSOIdentityService portalIdentityService = null;

    public JOSSOIdentityStore() {
        try {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            this.portalIdentityService = (JOSSOIdentityService)MBeanProxy.get(JOSSOIdentityService.class, (ObjectName)new ObjectName("portal:service=Module,type=JOSSOIdentityService"), (MBeanServer)mbeanServer);
            log.info((Object)"-------------------------------------------------------------------");
            log.info((Object)"JBoss Portal JOSSO Identity Store successfully started.............");
            log.info((Object)"-------------------------------------------------------------------");
        }
        catch (Exception e) {
            this.authenticationScheme = null;
            this.portalIdentityService = null;
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException("JOSSOIdentityStore registration failed....");
        }
    }

    public void setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        this.authenticationScheme = authenticationScheme;
    }

    public boolean userExists(UserKey userKey) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        return this.portalIdentityService.exists(userKey.toString());
    }

    public BaseRole[] findRolesByUserKey(UserKey userKey) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        String[] userRoles = this.portalIdentityService.getUserRoles(userKey.toString());
        BaseRole[] roles = new BaseRole[userRoles.length];
        for (int i = 0; i < userRoles.length; ++i) {
            roles[i] = new BaseRoleImpl(userRoles[i]);
        }
        return roles;
    }

    public BaseUser loadUser(UserKey userKey) throws NoSuchUserException, SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        BaseUserImpl user = new BaseUserImpl();
        user.setName(userKey.toString());
        user.addProperty("password", "");
        return user;
    }

    public Credential[] loadCredentials(CredentialKey credentialKey, CredentialProvider credentialProvider) throws SSOIdentityException {
        if (this.portalIdentityService == null) {
            throw new IllegalStateException("JOSSOIdentityStore not properly registered with the JOSSO system..");
        }
        BaseUser user = this.loadUser((UserKey)((SimpleUserKey)credentialKey));
        SSONameValuePair[] properties = user.getProperties();
        String password = properties[0].getValue();
        return new Credential[]{new UsernameCredential((Object)user.getName()), new PasswordCredential((Object)password)};
    }

    public boolean bind(String username, String password) throws SSOAuthenticationException {
        return this.portalIdentityService.authenticate(username, password);
    }
}

