/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl.render.dynamic;

import java.util.Map;

public class DynaRenderOptions {
    public static final String DND_ENABLED = "theme.dyna.dnd_enabled";
    public static final String PARTIAL_REFRESH_ENABLED = "theme.dyna.partial_refresh_enabled";
    public static final String BLOCKING_HTTP_GET_ENABLED = "theme.dyna.blocking_http_get_enabled";
    private static final DynaRenderOptions[] FLYWEIGHTS = new DynaRenderOptions[]{new DynaRenderOptions(null, null), new DynaRenderOptions(Boolean.TRUE, null), new DynaRenderOptions(Boolean.FALSE, null), null, new DynaRenderOptions(null, Boolean.TRUE), new DynaRenderOptions(Boolean.TRUE, Boolean.TRUE), new DynaRenderOptions(Boolean.FALSE, Boolean.TRUE), null, new DynaRenderOptions(null, Boolean.FALSE), new DynaRenderOptions(Boolean.TRUE, Boolean.FALSE), new DynaRenderOptions(Boolean.FALSE, Boolean.FALSE)};
    public static final DynaRenderOptions NO_AJAX = DynaRenderOptions.getOptions(Boolean.FALSE, Boolean.FALSE);
    public static final DynaRenderOptions AJAX = DynaRenderOptions.getOptions(Boolean.TRUE, Boolean.TRUE);
    private final Boolean dnd;
    private final Boolean partialRefresh;

    public static DynaRenderOptions getOptions(boolean dnd, boolean partialRefresh) {
        return DynaRenderOptions.getOptions((Boolean)dnd, (Boolean)partialRefresh);
    }

    public static DynaRenderOptions getOptions(Boolean dnd, Boolean partialRefresh) {
        int index;
        int n = dnd == null ? 0 : (index = dnd != false ? 1 : 2);
        return FLYWEIGHTS[index += partialRefresh == null ? 0 : (partialRefresh != false ? 4 : 8)];
    }

    public static DynaRenderOptions getOptions(String dndValue, String partialRefreshValue) {
        Boolean dnd = dndValue == null ? null : Boolean.valueOf(dndValue);
        Boolean partialRefresh = partialRefreshValue == null ? null : Boolean.valueOf(partialRefreshValue);
        return DynaRenderOptions.getOptions(dnd, partialRefresh);
    }

    public static DynaRenderOptions getOptions(Map propertyMap) {
        String dndValue = (String)propertyMap.get(DND_ENABLED);
        String partialRefreshValue = (String)propertyMap.get(PARTIAL_REFRESH_ENABLED);
        return DynaRenderOptions.getOptions(dndValue, partialRefreshValue);
    }

    public void setOptions(Map propertyMap) {
        if (this.dnd != null) {
            propertyMap.put(DND_ENABLED, this.dnd.toString());
        } else {
            propertyMap.remove(DND_ENABLED);
        }
        if (this.partialRefresh != null) {
            propertyMap.put(PARTIAL_REFRESH_ENABLED, this.partialRefresh.toString());
        } else {
            propertyMap.remove(PARTIAL_REFRESH_ENABLED);
        }
    }

    private DynaRenderOptions(Boolean dnd, Boolean partialRefresh) {
        this.dnd = dnd;
        this.partialRefresh = partialRefresh;
    }

    public Boolean getDnD() {
        return this.dnd;
    }

    public boolean isDnDEnabled() {
        return this.dnd != null && this.dnd != false;
    }

    public Boolean getPartialRefresh() {
        return this.partialRefresh;
    }

    public boolean isPartialRefreshEnabled() {
        return this.partialRefresh != null && this.partialRefresh != false;
    }
}

