/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl.render.dynamic;

import java.io.PrintWriter;
import org.jboss.portal.theme.impl.render.dynamic.DynaMergeBehavior;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;
import org.jboss.portal.theme.render.AbstractObjectRenderer;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.renderer.WindowRenderer;
import org.jboss.portal.theme.render.renderer.WindowRendererContext;

public class DynaWindowRenderer
extends AbstractObjectRenderer
implements WindowRenderer {
    private WindowRenderer delegate;
    static final ThreadLocal handleProvided = new ThreadLocal();

    public DynaWindowRenderer(WindowRenderer windowRenderer) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.delegate = windowRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RendererContext rendererContext, WindowRendererContext wrc) throws RenderException {
        DynaRenderOptions parentOptions = (DynaRenderOptions)rendererContext.getAttribute("dyna_render_options");
        if (parentOptions == null) {
            parentOptions = DynaRenderOptions.NO_AJAX;
        }
        try {
            String dndValue = wrc.getProperty("theme.dyna.dnd_enabled");
            String partialRefreshValue = wrc.getProperty("theme.dyna.partial_refresh_enabled");
            DynaRenderOptions windowOptions = DynaRenderOptions.getOptions(dndValue, partialRefreshValue);
            DynaRenderOptions options = DynaMergeBehavior.mergeForWindow(parentOptions, windowOptions);
            rendererContext.setAttribute("dyna_render_options", options);
            PrintWriter out = rendererContext.getWriter();
            if (!DynaRenderOptions.NO_AJAX.equals(parentOptions)) {
                out.print("<div class=\"dyna-window\">");
                out.print("<div id=\"");
                out.print(wrc.getId());
                if (options.isDnDEnabled()) {
                    if (options.isPartialRefreshEnabled()) {
                        out.print("\" class=\"dnd-window partial-refresh-window\">\n");
                    } else {
                        out.print("\" class=\"dnd-window\">\n");
                    }
                } else if (options.isPartialRefreshEnabled()) {
                    out.print("\" class=\"partial-refresh-window\">\n");
                } else {
                    out.print("\">\n");
                }
                this.delegate.render(rendererContext, wrc);
                out.print("</div></div>\n");
            } else {
                this.delegate.render(rendererContext, wrc);
            }
            handleProvided.set(null);
        }
        finally {
            rendererContext.setAttribute("dyna_render_options", parentOptions);
        }
    }
}

