/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.aspects.portlet;

import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.TransportGuarantee;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.info.SecurityInfo;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.InsufficientTransportGuaranteeResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.SecurityContext;

public class SecureTransportInterceptor
extends PortletInvokerInterceptor {
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
        PortletInfo containerInfo = container.getInfo();
        SecurityInfo securityInfo = containerInfo.getSecurity();
        SecurityContext securityContext = invocation.getSecurityContext();
        boolean invoke = true;
        if (!securityContext.isSecure()) {
            if (securityInfo.containsTransportGuarantee(TransportGuarantee.CONFIDENTIAL)) {
                invoke = false;
            } else if (securityInfo.containsTransportGuarantee(TransportGuarantee.INTEGRAL)) {
                invoke = false;
            }
        }
        if (invoke) {
            return super.invoke(invocation);
        }
        return new InsufficientTransportGuaranteeResponse();
    }
}

