/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.container;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.info.ContainerPreferenceInfo;
import org.jboss.portal.portlet.impl.info.ContainerPreferencesInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.state.DestroyCloneFailure;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.SimplePropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerPortletInvoker
extends PortletInvokerInterceptor {
    public static final String PORTLET_CONTAINER = "PORTLET_CONTAINER";
    private Map<String, Portlet> portlets = new HashMap<String, Portlet>();

    public void addPortletContainer(PortletContainer portletContainer) {
        HashMap<String, Portlet> portlets = new HashMap<String, Portlet>(this.portlets);
        PortletImpl portlet = new PortletImpl(portletContainer);
        portlets.put(portlet.getContext().getId(), portlet);
        this.portlets = portlets;
    }

    public void removePortletContainer(PortletContainer portletContainer) {
        HashMap<String, Portlet> portlets = new HashMap<String, Portlet>(this.portlets);
        PortletImpl portlet = new PortletImpl(portletContainer);
        portlets.remove(portlet.getContext().getId());
        this.portlets = portlets;
    }

    @Override
    public Set<Portlet> getPortlets() {
        return new HashSet<Portlet>(this.portlets.values());
    }

    @Override
    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (portletContext == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        String portletId = portletContext.getId();
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletId);
        if (portlet == null) {
            throw new NoSuchPortletException(portletId);
        }
        return portlet;
    }

    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException, InvocationException {
        PortletContext ctx = invocation.getTarget();
        PortletImpl portlet = (PortletImpl)this.getPortlet(ctx);
        PortletContainer container = portlet.container;
        try {
            invocation.setAttribute(PORTLET_CONTAINER, container);
            PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
            return portletInvocationResponse;
        }
        catch (Exception e) {
            if (e instanceof PortletInvokerException) {
                throw (PortletInvokerException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PortletInvokerException(e);
        }
        finally {
            invocation.removeAttribute(PORTLET_CONTAINER);
        }
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletContext.getId());
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        ContainerPortletInfo info = (ContainerPortletInfo)portlet.getInfo();
        ContainerPreferencesInfo prefs = info.getPreferences();
        SimplePropertyMap result = new SimplePropertyMap();
        for (String key : keys) {
            ContainerPreferenceInfo pref = prefs.getContainerPreference(key);
            if (pref == null) continue;
            result.put(key, pref.getDefaultValue());
        }
        return result;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        PortletImpl portlet = (PortletImpl)this.portlets.get(portletContext.getId());
        if (portlet == null) {
            throw new NoSuchPortletException(portletContext.getId());
        }
        ContainerPortletInfo info = (ContainerPortletInfo)portlet.getInfo();
        ContainerPreferencesInfo prefs = info.getPreferences();
        SimplePropertyMap result = new SimplePropertyMap();
        for (String key : prefs.getKeys()) {
            ContainerPreferenceInfo pref = prefs.getContainerPreference(key);
            if (pref == null) continue;
            result.put(key, pref.getDefaultValue());
        }
        return result;
    }

    @Override
    public PortletContext createClone(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static class PortletImpl
    implements Portlet {
        private final PortletContainer container;
        private final PortletContext context;

        public PortletImpl(PortletContainer container) {
            this.container = container;
            this.context = PortletContext.createPortletContext(container.getPortletApplication().getId() + "." + container.getId());
        }

        public PortletContext getContext() {
            return this.context;
        }

        public PortletInfo getInfo() {
            return this.container.getInfo();
        }

        public boolean isRemote() {
            return false;
        }

        public String toString() {
            return "Portlet[context=" + this.context + ",container=" + this.container + "]";
        }
    }
}

