/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.impl.info.ContainerParameterInfo;
import org.jboss.portal.portlet.impl.info.ContainerPortletApplicationInfo;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.jsr168.api.PortletContextImpl;
import org.jboss.portal.portlet.info.RuntimeOptionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletConfigImpl
implements PortletConfig {
    private final ContainerPortletInfo portletInfo;
    private final ContainerPortletApplicationInfo portletApplicationInfo;
    private final PortletContextImpl portletContext;
    private ResourceBundleManager bundleMgr;
    private List<QName> publishingEventQNames;
    private List<QName> processingEventQNames;
    private List<String> publicRenderParameterNames;
    private Map<String, String[]> containerRuntimeOptions;

    public PortletConfigImpl(ContainerPortletInfo portletInfo, ContainerPortletApplicationInfo portletApplicationInfo, PortletContextImpl portletContext, ResourceBundleManager bundleMgr) {
        ArrayList<String> publicRenderParameterNames = new ArrayList<String>();
        for (ContainerParameterInfo parameterInfo : portletInfo.getNavigation().getPublicParameters()) {
            publicRenderParameterNames.add(parameterInfo.getId());
        }
        ParameterMap tmp = null;
        for (RuntimeOptionInfo option : portletInfo.getRuntimeOptionsInfo().values()) {
            String name = option.getName();
            if (!RuntimeOptionInfo.SUPPORTED_OPTIONS.contains(name)) continue;
            if (tmp == null) {
                tmp = new ParameterMap(ParameterMap.AccessMode.get((boolean)true, (boolean)false));
            }
            String[] values = option.getValues().toArray(new String[option.getValues().size()]);
            tmp.setValues(name, values);
        }
        Map containerRuntimeOptions = tmp != null ? Collections.unmodifiableMap(tmp) : Collections.emptyMap();
        this.portletInfo = portletInfo;
        this.portletApplicationInfo = portletApplicationInfo;
        this.portletContext = portletContext;
        this.bundleMgr = bundleMgr;
        this.publishingEventQNames = new ArrayList<QName>(portletInfo.getEventing().getProducedEvents().keySet());
        this.processingEventQNames = new ArrayList<QName>(portletInfo.getEventing().getConsumedEvents().keySet());
        this.publicRenderParameterNames = publicRenderParameterNames;
        this.containerRuntimeOptions = containerRuntimeOptions;
    }

    public String getPortletName() {
        return this.portletInfo.getName();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.bundleMgr.getResourceBundle(locale);
    }

    public String getInitParameter(String s) {
        if (s == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.portletInfo.getInitParameter(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.portletInfo.getInitParameterNames());
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        return Collections.enumeration(this.publicRenderParameterNames);
    }

    public String getDefaultNamespace() {
        return this.portletApplicationInfo.getDefaultNamespace();
    }

    public Enumeration<QName> getPublishingEventQNames() {
        return Collections.enumeration(this.publishingEventQNames);
    }

    public Enumeration<QName> getProcessingEventQNames() {
        return Collections.enumeration(this.processingEventQNames);
    }

    public Enumeration<Locale> getSupportedLocales() {
        return Collections.enumeration(this.portletInfo.getCapabilities().getAllLocales());
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this.containerRuntimeOptions;
    }
}

