/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.SimplePropertyMap;
import org.jboss.portal.portlet.state.StateConversionException;
import org.jboss.portal.portlet.state.StateConverter;
import org.jboss.portal.portlet.state.producer.PortletState;

public class StateConverterV0
implements StateConverter {
    private static final int MAGIC_VALUE = -1101552363;
    private static final byte VERSION_ID = 0;

    public byte[] marshall(PortletState state) throws StateConversionException {
        if (state == null) {
            throw new IllegalArgumentException("No null state");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(-1101552363);
            dos.write(0);
            dos.writeUTF(state.getPortletId());
            PropertyMap map = state.getProperties();
            dos.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                String[] strings = value.toArray(new String[value.size()]);
                dos.writeUTF(key);
                dos.writeInt(strings.length);
                for (String string : strings) {
                    if (string == null) {
                        dos.writeBoolean(true);
                        continue;
                    }
                    dos.writeBoolean(false);
                    dos.writeUTF(string);
                }
            }
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new StateConversionException(e);
        }
    }

    public PortletState unmarshall(byte[] marshalledState) throws StateConversionException {
        if (marshalledState == null) {
            throw new IllegalArgumentException("No null bytes");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(marshalledState);
            DataInputStream dis = new DataInputStream(bais);
            int magicValue = dis.readInt();
            if (magicValue != -1101552363) {
                throw new StateConversionException("Bad magic value " + Integer.toHexString(magicValue));
            }
            byte versionId = dis.readByte();
            if (versionId > 0) {
                throw new StateConversionException("Bad version id " + versionId);
            }
            String portletId = dis.readUTF();
            int size = dis.readInt();
            SimplePropertyMap properties = new SimplePropertyMap(size);
            while (size-- > 0) {
                String key = dis.readUTF();
                int length = dis.readInt();
                String[] strings = new String[length];
                for (int i = 0; i < strings.length; ++i) {
                    String string;
                    boolean isNull = dis.readBoolean();
                    if (isNull) continue;
                    strings[i] = string = dis.readUTF();
                }
                List<Object> value = Arrays.asList((Object[])strings.clone());
                properties.setProperty(key, value);
            }
            return new PortletState(portletId, properties);
        }
        catch (IOException e) {
            throw new StateConversionException(e);
        }
    }
}

