/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.state.producer;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.portlet.impl.state.producer.PortletStateContextImpl;
import org.jboss.portal.portlet.state.InvalidStateIdException;
import org.jboss.portal.portlet.state.NoSuchStateException;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.SimplePropertyMap;
import org.jboss.portal.portlet.state.producer.PortletState;
import org.jboss.portal.portlet.state.producer.PortletStateContext;
import org.jboss.portal.portlet.state.producer.PortletStatePersistenceManager;

public class PortletStatePersistenceManagerService
implements PortletStatePersistenceManager {
    private Map<String, PortletStateContext> store = new HashMap<String, PortletStateContext>();
    private int counter = 0;

    public synchronized PortletStateContext loadState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        if (stateId == null) {
            throw new IllegalArgumentException("No null state id accepted");
        }
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException(e, stateId);
        }
        PortletStateContext context = this.store.get(stateId);
        if (context == null) {
            throw new NoSuchStateException(stateId);
        }
        return context;
    }

    private synchronized PortletState getState(String stateId) throws NoSuchStateException, InvalidStateIdException {
        PortletStateContext context = this.loadState(stateId);
        return context.getState();
    }

    public synchronized String createState(String portletId, PropertyMap propertyMap) {
        if (portletId == null) {
            throw new IllegalArgumentException("No null portlet id accepted");
        }
        if (propertyMap == null) {
            throw new IllegalArgumentException("No null value map accepted");
        }
        String id = Integer.toString(this.counter++);
        PortletStateContextImpl state = new PortletStateContextImpl(id, portletId, new SimplePropertyMap(propertyMap));
        this.store.put(id, state);
        return id;
    }

    public synchronized String cloneState(String stateId, PropertyMap propertyMap) throws NoSuchStateException, InvalidStateIdException {
        if (propertyMap == null) {
            throw new IllegalArgumentException();
        }
        PortletState stateContext = this.getState(stateId);
        return this.createState(stateContext.getPortletId(), propertyMap);
    }

    public String cloneState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        PortletState state = this.getState(stateId);
        return this.createState(state.getPortletId(), new SimplePropertyMap(state.getProperties()));
    }

    public synchronized void updateState(String stateId, PropertyMap propertyMap) throws NoSuchStateException, InvalidStateIdException {
        if (propertyMap == null) {
            throw new IllegalArgumentException("No null value map");
        }
        PortletState ctx = this.getState(stateId);
        ctx.getProperties().clear();
        ctx.getProperties().putAll(propertyMap);
    }

    public synchronized void destroyState(String stateId) throws InvalidStateIdException, NoSuchStateException {
        if (stateId == null) {
            throw new IllegalArgumentException();
        }
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException(e, stateId);
        }
        if (this.store.remove(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
    }

    public synchronized int getSize() {
        return this.store.size();
    }
}

