/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.logging;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootCategory;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.util.ResourceLoader;
import org.jboss.portal.common.util.Tools;
import org.w3c.dom.Document;

public class LoaderRepositorySelector
implements RepositorySelector {
    private static boolean initialized = false;
    private static Object guard = LogManager.getRootLogger();
    private static Map repositories = new HashMap();
    private static LoggerRepository defaultRepository;
    private static Logger log;

    public static synchronized void register(ClassLoader classloader, ResourceLoader loader, String pathToLog4jFile) {
        if (classloader == null) {
            throw new IllegalArgumentException("No classloader provided");
        }
        if (loader == null) {
            throw new IllegalArgumentException("No loader provided");
        }
        if (pathToLog4jFile == null) {
            throw new IllegalArgumentException("No pathToLog4jFile provided");
        }
        if (!initialized) {
            LoaderRepositorySelector theSelector = new LoaderRepositorySelector();
            LogManager.setRepositorySelector((RepositorySelector)theSelector, (Object)guard);
            initialized = true;
        }
        InputStream log4JConfig = null;
        try {
            log4JConfig = loader.load(pathToLog4jFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(log4JConfig);
            DOMConfigurator conf = new DOMConfigurator();
            Hierarchy hierarchy = new Hierarchy((Logger)new RootCategory(Level.DEBUG));
            conf.doConfigure(doc.getDocumentElement(), (LoggerRepository)hierarchy);
            repositories.put(classloader, hierarchy);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalArgumentException("Cannot load log4j configuration");
        }
        finally {
            IOTools.safeClose(log4JConfig);
        }
    }

    public static synchronized void unregister(ClassLoader classloader) {
        if (classloader == null) {
            throw new IllegalArgumentException("No classloader provided");
        }
        Hierarchy hierarchy = (Hierarchy)repositories.remove(classloader);
        if (hierarchy != null) {
            hierarchy.shutdown();
        } else {
            System.out.print("No hierarchy found for classloader : ");
            PrintWriter writer = new PrintWriter(System.out);
            Tools.dumpClassLoaderHierarchyInfo(writer, classloader);
        }
    }

    private LoaderRepositorySelector() {
    }

    public LoggerRepository getLoggerRepository() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        LoggerRepository repository = (LoggerRepository)repositories.get(loader);
        if (repository == null) {
            return defaultRepository;
        }
        return repository;
    }

    static {
        log = Logger.getLogger(LoaderRepositorySelector.class);
    }
}

