/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.classic;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.RedirectionResponse;
import org.jboss.portal.core.controller.command.response.SecurityErrorResponse;
import org.jboss.portal.core.controller.command.response.SignOutResponse;
import org.jboss.portal.core.controller.command.response.StreamContentResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.controller.handler.HTTPResponse;
import org.jboss.portal.core.controller.handler.HandlerResponse;
import org.jboss.portal.core.controller.handler.ResponseHandler;
import org.jboss.portal.core.controller.handler.ResponseHandlerException;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.command.view.ViewPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.request.URLContext;
import org.jboss.portal.web.ServletContextDispatcher;

public class OtherResponseHandler
implements ResponseHandler {
    private static final Logger log = Logger.getLogger(OtherResponseHandler.class);

    public HandlerResponse processCommandResponse(ControllerContext controllerContext, ControllerCommand controllerCommand, ControllerResponse controllerResponse) throws ResponseHandlerException {
        final ServerInvocation invocation = controllerContext.getServerInvocation();
        if (controllerResponse instanceof PageRendition) {
            final PageRendition rendition = (PageRendition)controllerResponse;
            return new HTTPResponse(){

                public void sendResponse(ServerInvocationContext ctx) throws IOException, ServletException {
                    ServletContextDispatcher dispatcher = new ServletContextDispatcher(invocation.getServerContext().getClientRequest(), invocation.getServerContext().getClientResponse(), invocation.getRequest().getServer().getServletContainer());
                    MarkupInfo markupInfo = (MarkupInfo)invocation.getResponse().getContentInfo();
                    rendition.render(markupInfo, dispatcher);
                }
            };
        }
        if (controllerResponse instanceof SignOutResponse) {
            String location = ((SignOutResponse)controllerResponse).getLocation();
            invocation.getResponse().setWantSignOut(true);
            if (location == null) {
                PortalObjectContainer portalObjectContainer = controllerContext.getController().getPortalObjectContainer();
                Portal portal = portalObjectContainer.getContext().getDefaultPortal();
                ViewPageCommand renderCmd = new ViewPageCommand(portal.getId());
                URLContext urlContext = invocation.getServerContext().getURLContext();
                location = controllerContext.renderURL(renderCmd, urlContext.asNonAuthenticated(), null);
            }
            return HTTPResponse.sendRedirect(location);
        }
        if (controllerResponse instanceof RedirectionResponse) {
            String location = ((RedirectionResponse)controllerResponse).getLocation();
            if (location == null) {
                PortalObjectContainer portalObjectContainer = controllerContext.getController().getPortalObjectContainer();
                Portal portal = portalObjectContainer.getContext().getDefaultPortal();
                ViewPageCommand renderCmd = new ViewPageCommand(portal.getId());
                URLContext urlContext = invocation.getServerContext().getURLContext();
                location = controllerContext.renderURL(renderCmd, urlContext, null);
            }
            return HTTPResponse.sendRedirect(location);
        }
        if (controllerResponse instanceof StreamContentResponse) {
            StreamContentResponse scr = (StreamContentResponse)controllerResponse;
            if (scr.getInputStream() != null) {
                return HTTPResponse.sendBinary(scr.getContentType(), scr.getLastModified(), scr.getProperties(), scr.getInputStream());
            }
            return HTTPResponse.sendBinary(scr.getContentType(), scr.getLastModified(), scr.getProperties(), scr.getReader());
        }
        if (controllerResponse instanceof SecurityErrorResponse) {
            SecurityErrorResponse ser = (SecurityErrorResponse)controllerResponse;
            URLContext urlContext = controllerContext.getServerInvocation().getServerContext().getURLContext();
            if (ser.getStatus() == 0) {
                if (controllerContext.getUser() != null) {
                    return HTTPResponse.sendForbidden();
                }
                urlContext = URLContext.newInstance((boolean)urlContext.isSecure(), (boolean)true);
                ServerURL serverURL = controllerContext.getController().getURLFactory().doMapping(controllerContext, controllerContext.getServerInvocation(), controllerCommand);
                String url = controllerContext.getServerInvocation().getResponse().renderURL(serverURL, urlContext, null);
                return HTTPResponse.sendRedirect(url);
            }
            urlContext = URLContext.newInstance((boolean)true, (boolean)urlContext.isAuthenticated());
            ServerURL serverURL = controllerContext.getController().getURLFactory().doMapping(controllerContext, controllerContext.getServerInvocation(), controllerCommand);
            String url = controllerContext.getServerInvocation().getResponse().renderURL(serverURL, urlContext, null);
            return HTTPResponse.sendRedirect(url);
        }
        if (controllerResponse instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)controllerResponse;
            Throwable cause = errorResponse.getCause();
            if (cause != null) {
                log.error((Object)"An error occured", cause);
            }
            return HTTPResponse.sendError(errorResponse.getMessage());
        }
        if (controllerResponse instanceof UnavailableResourceResponse) {
            return HTTPResponse.sendNotFound();
        }
        return null;
    }
}

