/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.portal.core.controller.coordination.CoordinationManager;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.controller.event.EventControllerContext;
import org.jboss.portal.portlet.controller.event.EventPhaseContext;
import org.jboss.portal.portlet.controller.event.PortletWindowEvent;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;

public class CoreEventControllerContext
implements EventControllerContext {
    private final Logger log = Logger.getLogger(CoreEventControllerContext.class);
    private final ControllerPortletControllerContext portletControllerContext;
    private LinkedList<PortletWindowEvent> toConsumeEvents;

    public CoreEventControllerContext(ControllerPortletControllerContext portletControllerContext) {
        this.portletControllerContext = portletControllerContext;
        this.toConsumeEvents = new LinkedList();
    }

    public void eventProduced(EventPhaseContext context, PortletWindowEvent producedEvent, PortletWindowEvent sourceEvent) {
        try {
            CoordinationManager coordinationManager = this.portletControllerContext.getControllerContext().getController().getCoordinationManager();
            Map<Window, PortletWindowEvent> windows = coordinationManager.getEventWindows(producedEvent, this.portletControllerContext);
            for (PortletWindowEvent event : windows.values()) {
                context.queueEvent(event);
            }
            if ("urn:jboss:portal".equals(producedEvent.getName().getNamespaceURI())) {
                this.toConsumeEvents.addLast(producedEvent);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"An error occured when an event was routed", (Throwable)e);
            context.interrupt();
        }
    }

    public void eventConsumed(EventPhaseContext context, PortletWindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
    }

    public void eventFailed(EventPhaseContext context, PortletWindowEvent failedEvent, Throwable throwable) {
        this.log.error((Object)("Could not deliver event " + failedEvent.getName() + " to portlet window " + failedEvent.getWindowId()), throwable);
    }

    public void eventDiscarded(EventPhaseContext context, PortletWindowEvent discardedEvent, int cause) {
    }
}

