/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.cache;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.jboss.logging.Logger;
import org.jboss.portal.core.identity.cache.IdentityCacheService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.ldap.LDAPUserModule;

public class CachedLDAPUserModuleWrapper
extends LDAPUserModule
implements UserModule {
    private LDAPUserModule userModule;
    private IdentityCacheService cacheService;
    private static final Logger log = Logger.getLogger(CachedLDAPUserModuleWrapper.class);

    public CachedLDAPUserModuleWrapper(LDAPUserModule userModule, IdentityCacheService cacheService) {
        this.userModule = userModule;
        this.cacheService = cacheService;
    }

    public User findUserByUserName(String userName) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        if (userName == null) {
            throw new IllegalArgumentException("UserName cannot be null");
        }
        User user = this.cacheService.findUserByUserName(userName);
        if (user != null) {
            return user;
        }
        user = this.userModule.findUserByUserName(userName);
        this.cacheService.storeUser(user);
        return user;
    }

    public User findUserById(Object id) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        if (id == null) {
            throw new IllegalArgumentException("User id cannot be null");
        }
        User user = this.cacheService.findUserById(id);
        if (user != null) {
            return user;
        }
        user = this.userModule.findUserById(id);
        this.cacheService.storeUser(user);
        return user;
    }

    public User findUserById(String id) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        return this.findUserById((Object)id);
    }

    public User createUser(String userName, String password) throws IdentityException, IllegalArgumentException {
        return this.userModule.createUser(userName, password);
    }

    public void removeUser(Object id) throws IdentityException, IllegalArgumentException {
        this.userModule.removeUser(id);
        User user = this.cacheService.findUserById(id);
        if (user != null) {
            this.cacheService.invalidateUser(user);
        }
    }

    public Set findUsers(int offset, int limit) throws IdentityException, IllegalArgumentException {
        return this.userModule.findUsers(offset, limit);
    }

    public Set findUsersFilteredByUserName(String filter, int offset, int limit) throws IdentityException, IllegalArgumentException {
        return this.userModule.findUsersFilteredByUserName(filter, offset, limit);
    }

    public int getUserCount() throws IdentityException, IllegalArgumentException {
        return this.userModule.getUserCount();
    }

    public List searchUsers(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        return this.userModule.searchUsers(filter, filterArgs);
    }

    public void updatePassword(LDAPUserImpl ldapu, String password) throws IdentityException {
        this.userModule.updatePassword(ldapu, password);
    }

    public boolean validatePassword(LDAPUserImpl ldapu, String password) throws IdentityException {
        return this.userModule.validatePassword(ldapu, password);
    }

    public LDAPUserImpl createUserInstance(Attributes attrs, String dn) throws IdentityException {
        return this.userModule.createUserInstance(attrs, dn);
    }

    public User findUserByDN(String dn) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        return this.userModule.findUserByDN(dn);
    }
}

