/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.api.navstate;

import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.api.navstate.NavigationalStateContext;
import org.jboss.portal.api.node.PortalNode;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.core.impl.api.node.PortalNodeImpl;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;

public class NavigationalStateContextImpl
implements NavigationalStateContext {
    private AttributeResolver navigationalStateResolver;

    public NavigationalStateContextImpl(AttributeResolver navigationalStateResolver) {
        this.navigationalStateResolver = navigationalStateResolver;
    }

    private WindowNavigationalState getWNS(PortalNode window, boolean create) {
        PortalNodeImpl pon = (PortalNodeImpl)window;
        NavigationalStateKey key = new NavigationalStateKey(WindowNavigationalState.class, pon.getObjectId());
        WindowNavigationalState wns = (WindowNavigationalState)this.navigationalStateResolver.getAttribute((Object)key);
        if (wns == null && create) {
            wns = WindowNavigationalState.create();
            this.navigationalStateResolver.setAttribute((Object)key, (Object)wns);
        }
        return wns;
    }

    public WindowState getWindowState(PortalNode window) throws IllegalArgumentException {
        if (window == null) {
            throw new IllegalArgumentException("No null window can be provided");
        }
        WindowNavigationalState wns = this.getWNS(window, false);
        if (wns != null) {
            return wns.getWindowState();
        }
        return null;
    }

    public void setWindowState(PortalNode window, WindowState windowState) throws IllegalArgumentException {
        if (window == null) {
            throw new IllegalArgumentException("No null window can be provided");
        }
        if (windowState == null) {
            throw new IllegalArgumentException();
        }
        PortalNodeImpl pon = (PortalNodeImpl)window;
        WindowNavigationalState.setWindowState(this.navigationalStateResolver, pon.getObjectId(), windowState);
    }

    public Mode getMode(PortalNode window) throws IllegalArgumentException {
        if (window == null) {
            throw new IllegalArgumentException("No null window can be provided");
        }
        WindowNavigationalState wns = this.getWNS(window, false);
        if (wns != null) {
            return wns.getMode();
        }
        return null;
    }

    public void setMode(PortalNode window, Mode mode) throws IllegalArgumentException {
        if (window == null) {
            throw new IllegalArgumentException("No null window can be provided");
        }
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        PortalNodeImpl pon = (PortalNodeImpl)window;
        WindowNavigationalState.setMode(this.navigationalStateResolver, pon.getObjectId(), mode);
    }
}

