/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance.persistent;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.portal.core.model.instance.Instance;

final class PersistentRoleSecurityBinding
implements Serializable {
    private static final long serialVersionUID = -2832148715381794267L;
    private Long key;
    private String role;
    private Set actions;
    private transient String toString;
    private transient int hashCode;
    private transient String actionsAsString;
    private Instance instance;

    public PersistentRoleSecurityBinding() {
    }

    public PersistentRoleSecurityBinding(String actions, String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions cannot be null");
        }
        StringTokenizer tokens = new StringTokenizer(actions, ",");
        HashSet<String> set = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            set.add(tokens.nextToken().trim());
        }
        this.role = role;
        this.actions = Collections.unmodifiableSet(set);
    }

    public PersistentRoleSecurityBinding(Set actions, String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Actions cannot be null");
        }
        this.role = role;
        this.actions = Collections.unmodifiableSet(new HashSet(actions));
    }

    public PersistentRoleSecurityBinding(PersistentRoleSecurityBinding other) {
        if (other == null) {
            throw new IllegalArgumentException("The constraint to clone cannot be null");
        }
        this.role = other.role;
        this.actions = other.actions;
    }

    public Set getActions() {
        return this.actions;
    }

    public String getRole() {
        return this.role;
    }

    public String getActionsAsString() {
        if (this.actionsAsString == null) {
            StringBuffer tmp = new StringBuffer();
            Iterator i = this.actions.iterator();
            while (i.hasNext()) {
                String action = (String)i.next();
                if (i.hasNext()) {
                    tmp.append(", ");
                }
                tmp.append(action);
            }
            this.actionsAsString = tmp.toString();
        }
        return this.actionsAsString;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer tmp = new StringBuffer("SecurityConstraint: actions [");
            Iterator i = this.actions.iterator();
            while (i.hasNext()) {
                String action = (String)i.next();
                if (i.hasNext()) {
                    tmp.append(", ");
                }
                tmp.append(action);
            }
            tmp.append("] role [").append(this.role).append("]");
            this.toString = tmp.toString();
        }
        return this.toString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PersistentRoleSecurityBinding) {
            PersistentRoleSecurityBinding that = (PersistentRoleSecurityBinding)o;
            return ((Object)this.actions).equals(that.actions) && this.role.equals(that.role);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hashCode = ((Object)this.actions).hashCode();
            this.hashCode = hashCode = 29 * hashCode + this.role.hashCode();
        }
        return this.hashCode;
    }

    protected void setKey(Long k) {
        this.key = k;
    }

    protected Long getKey() {
        return this.key;
    }

    public void setActions(Set actions) {
        this.actions = actions;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }
}

