/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal;

import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.provider.PermissionRepository;

public final class PortalObjectPermission
extends PortalPermission {
    private static final long serialVersionUID = -4796595968918579499L;
    public static final String CREATE_ACTION = "create";
    public static final String VIEW_ACTION = "view";
    public static final String VIEW_RECURSIVE_ACTION = "viewrecursive";
    public static final String PERSONALIZE_ACTION = "personalize";
    public static final String PERSONALIZE_RECURSIVE_ACTION = "personalizerecursive";
    public static final String DASHBOARD_ACTION = "dashboard";
    public static final int NONE_MASK = 0;
    public static final int VIEW_MASK = 1;
    public static final int CREATE_MASK = 2;
    public static final int PERSONALIZE_MASK = 4;
    public static final int DASHBOARD_MASK = 8;
    private static final String[] ACTION_NAMES = new String[]{"view", "create", "personalize", "dashboard"};
    private PortalObjectId id;
    private int mask;
    private int recursiveMask;
    private String actions;
    public static final String PERMISSION_TYPE = "portalobject";

    public PortalObjectPermission(PortalPermissionCollection collection) {
        super("portalobjectpermission", collection);
    }

    public PortalObjectPermission(PortalObjectId id, Collection actions) {
        super("portalobjectpermission", id.toString(PortalObjectPath.CANONICAL_FORMAT));
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        this.id = id;
        for (String action : actions) {
            this.addAction(action);
        }
        this.mask |= this.recursiveMask;
    }

    public PortalObjectPermission(PortalObjectId id, String actions) {
        super("portalobjectpermission", id.toString(PortalObjectPath.CANONICAL_FORMAT));
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        this.id = id;
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            this.addAction(action);
        }
        this.mask |= this.recursiveMask;
    }

    public PortalObjectPermission(PortalObjectId id, int mask, int recursiveMask) {
        super("portalobjectpermission", id.toString(PortalObjectPath.CANONICAL_FORMAT));
        this.id = id;
        this.mask = mask | recursiveMask;
        this.recursiveMask = recursiveMask;
    }

    public PortalObjectPermission(PortalObjectId id, int mask) {
        super("portalobjectpermission", id.toString(PortalObjectPath.CANONICAL_FORMAT));
        this.id = id;
        this.mask = mask;
        this.recursiveMask = 0;
    }

    private void addAction(String action) throws IllegalArgumentException {
        if (VIEW_ACTION.equals(action)) {
            this.mask |= 1;
        } else if (VIEW_RECURSIVE_ACTION.equals(action)) {
            this.recursiveMask |= 1;
        } else if (CREATE_ACTION.equals(action)) {
            this.mask |= 2;
        } else if (PERSONALIZE_ACTION.equals(action)) {
            this.mask |= 4;
        } else if (PERSONALIZE_RECURSIVE_ACTION.equals(action)) {
            this.recursiveMask |= 4;
        } else if (DASHBOARD_ACTION.equals(action)) {
            this.mask |= 8;
        } else {
            throw new IllegalArgumentException("Illegal action " + action);
        }
    }

    public boolean implies(PermissionRepository repository, Subject caller, String roleName, PortalPermission permission) throws PortalSecurityException {
        if (permission instanceof PortalObjectPermission) {
            PortalObjectPermission pop = (PortalObjectPermission)permission;
            if (pop.isContainer()) {
                return false;
            }
            String namespace = pop.id.getNamespace();
            PortalObjectPath path = pop.id.getPath();
            while (true) {
                String uri;
                PortalObjectPermission loaded;
                if ((loaded = (PortalObjectPermission)repository.getPermission(roleName, uri = PortalObjectId.toString(namespace, path, PortalObjectPath.CANONICAL_FORMAT))) != null && loaded.implies((Permission)((Object)pop), caller)) {
                    return true;
                }
                if (path.getLength() == 0) {
                    return false;
                }
                path = path.getParent();
            }
        }
        return false;
    }

    public boolean implies(Permission permission) {
        return this.implies(permission, null);
    }

    public boolean implies(Permission permission, Subject caller) {
        PortalObjectPermission that;
        if (permission instanceof PortalObjectPermission && !this.isContainer() && !(that = (PortalObjectPermission)((Object)permission)).isContainer()) {
            Set<Principal> tmp;
            if (!this.id.getNamespace().equals(that.id.getNamespace())) {
                return false;
            }
            PortalObjectPath thisPath = this.id.getPath();
            PortalObjectPath thatPath = that.id.getPath();
            if ((this.mask & 8) == 8 && caller != null && thisPath.getLength() < thatPath.getLength() && (tmp = caller.getPrincipals()).size() > 0) {
                Iterator i1 = thisPath.names();
                Iterator i2 = thatPath.names();
                while (i1.hasNext()) {
                    String name2;
                    String name1 = (String)i1.next();
                    if (name1.equals(name2 = (String)i2.next())) continue;
                    return false;
                }
                Iterator<Principal> i = tmp.iterator();
                Principal user = i.next();
                String userName = user.getName();
                return userName.equals(i2.next());
            }
            if (that.uri.equals(this.uri)) {
                if (that.recursiveMask != 0 && (this.recursiveMask & that.mask) != that.mask) {
                    return false;
                }
                return (this.mask & that.mask) == that.mask;
            }
            if (that.uri.startsWith(this.uri)) {
                return (this.recursiveMask & that.mask) == that.mask;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PortalObjectPermission) {
            PortalObjectPermission that = (PortalObjectPermission)((Object)obj);
            if (this.isContainer()) {
                return that.isContainer();
            }
            return this.mask == that.mask && this.uri.equals(that.uri);
        }
        return false;
    }

    public int hashCode() {
        if (this.isContainer()) {
            return 0;
        }
        return this.uri.hashCode() * 43 + this.mask;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < ACTION_NAMES.length; ++i) {
                int mask = 2 >> i;
                if ((this.mask & mask) == mask) {
                    tmp.append(ACTION_NAMES[i]);
                    if ((this.recursiveMask & mask) == mask) {
                        tmp.append("recursive,");
                        continue;
                    }
                    tmp.append(',');
                    continue;
                }
                if ((this.recursiveMask & mask) != mask) continue;
                tmp.append(ACTION_NAMES[i]).append("recursive,");
            }
            int length = tmp.length();
            if (length > 0) {
                tmp.setLength(length - 1);
            }
            this.actions = tmp.toString();
        }
        return this.actions;
    }

    public String getType() {
        return PERMISSION_TYPE;
    }

    public PortalObjectId getId() {
        return this.id;
    }
}

