/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.as.system;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.portal.jems.as.system.AbstractJBossService;

public class LifecycleInvoker
extends AbstractJBossService {
    private ObjectName target;
    private String onCreate;
    private String onStart;
    private String onStop;
    private String onDestroy;

    public ObjectName getTarget() {
        return this.target;
    }

    public void setTarget(ObjectName target) {
        this.target = target;
    }

    public String getOnCreate() {
        return this.onCreate;
    }

    public void setOnCreate(String onCreate) {
        this.onCreate = onCreate;
    }

    public String getOnStart() {
        return this.onStart;
    }

    public void setOnStart(String onStart) {
        this.onStart = onStart;
    }

    public String getOnStop() {
        return this.onStop;
    }

    public void setOnStop(String onStop) {
        this.onStop = onStop;
    }

    public String getOnDestroy() {
        return this.onDestroy;
    }

    public void setOnDestroy(String onDestroy) {
        this.onDestroy = onDestroy;
    }

    private void invoke(String methodName) {
        try {
            this.log.debug((Object)("About to invoke " + methodName + " on mbean " + this.target));
            this.server.invoke(this.target, methodName, new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException e) {
            this.log.debug((Object)("The mbean " + this.target + " does not exist and " + methodName + " cannot be invoked"));
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            this.log.error((Object)("The mbean " + this.target + " threw an exception during the invocation of the method " + methodName), t);
        }
        catch (ReflectionException e) {
            this.log.error((Object)("The mbean " + this.target + " invocation of method " + methodName), (Throwable)e);
        }
    }

    protected void createService() throws Exception {
        if (this.onCreate != null) {
            this.invoke(this.onCreate);
        }
    }

    protected void startService() throws Exception {
        if (this.onStart != null) {
            this.invoke(this.onStart);
        }
    }

    protected void stopService() throws Exception {
        if (this.onStop != null) {
            this.invoke(this.onStop);
        }
    }

    protected void destroyService() throws Exception {
        if (this.onDestroy != null) {
            this.invoke(this.onDestroy);
        }
    }
}

