/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.jboss.portal.common.io.IOTools;

public final class ByteArrayBlob
implements Blob {
    byte[] _bytes;

    public ByteArrayBlob(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOTools.copy((InputStream)in, (OutputStream)out);
        this._bytes = out.toByteArray();
    }

    public ByteArrayBlob(ByteArrayBlob that) {
        this._bytes = that.getBytes(0L, that._bytes.length);
    }

    public ByteArrayBlob(byte[] _bytes) {
        this._bytes = _bytes;
    }

    public ByteArrayBlob(Blob blob) throws SQLException {
        this._bytes = blob.getBytes(1L, (int)blob.length());
    }

    public long length() {
        return this._bytes.length;
    }

    public byte[] getBytes(long pos, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this._bytes, 0, bytes, 0, length);
        return bytes;
    }

    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this._bytes);
    }

    public InputStream getBinaryStream(long pos, long length) {
        throw new UnsupportedOperationException();
    }

    public void free() {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long pos) {
        throw new UnsupportedOperationException();
    }

    public long position(byte[] pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public long position(Blob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) {
        throw new UnsupportedOperationException();
    }

    public static ByteArrayBlob get(Blob blob) throws IOException, SQLException {
        if (blob instanceof ByteArrayBlob) {
            return (ByteArrayBlob)blob;
        }
        InputStream binaryStream = blob.getBinaryStream();
        return new ByteArrayBlob(binaryStream);
    }

    public static ByteArrayBlob create(Blob blob) throws IOException, SQLException {
        if (blob instanceof ByteArrayBlob) {
            return new ByteArrayBlob((ByteArrayBlob)blob);
        }
        InputStream binaryStream = blob.getBinaryStream();
        return new ByteArrayBlob(binaryStream);
    }
}

