/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.impl.invocation;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.portal.common.invocation.AttributeResolver;

public class SessionAttributeResolver
implements AttributeResolver {
    protected final HttpServletRequest req;
    protected final String prefix;
    protected String anonymousPrefix;

    public SessionAttributeResolver(HttpServletRequest req, String prefix, boolean principalScoped) {
        Principal principal;
        if (req == null) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (principalScoped && (principal = req.getUserPrincipal()) != null) {
            this.anonymousPrefix = prefix;
            prefix = prefix + principal.getName();
        }
        this.req = req;
        this.prefix = prefix;
    }

    public Set getKeys() {
        HttpSession session = this.req.getSession(false);
        if (session == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> keys = new HashSet<String>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(this.prefix)) continue;
            keys.add(key);
        }
        return keys;
    }

    public Object getAttribute(Object o) throws IllegalArgumentException {
        HttpSession session = this.req.getSession(false);
        if (session == null) {
            return null;
        }
        Object returnValue = session.getAttribute(this.prefix + o);
        if (returnValue == null && this.anonymousPrefix != null && o.toString().endsWith("_CMS_LAYOUT")) {
            returnValue = session.getAttribute(this.anonymousPrefix + o);
        }
        return returnValue;
    }

    public void setAttribute(Object o, Object o1) throws IllegalArgumentException {
        this.req.getSession().setAttribute(this.prefix + o, o1);
    }
}

