/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.impl.invocation.JBossPortletInterceptorStack;
import org.jboss.portal.portlet.impl.invocation.PortletInterceptorStack;
import org.jboss.portal.portlet.impl.invocation.PortletInterceptorStackFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPortletInterceptorStackFactory
extends AbstractJBossService
implements PortletInterceptorStackFactory {
    protected List<ObjectName> interceptorNames = null;
    protected List<ObjectName> dynamicInterceptorNames = new ArrayList<ObjectName>();
    protected PortletInterceptorStack stack;

    public List<ObjectName> getInterceptorNames() {
        return this.interceptorNames;
    }

    public void setInterceptorNames(List<ObjectName> interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public List<ObjectName> getDynamicInterceptorNames() {
        return Collections.unmodifiableList(this.dynamicInterceptorNames);
    }

    public void addInterceptor(ObjectName name) throws Exception {
        this.dynamicInterceptorNames.add(name);
    }

    public void removeInterceptor(ObjectName name) throws Exception {
        this.dynamicInterceptorNames.remove(name);
    }

    public void startService() throws Exception {
        this.rebuild();
    }

    public void rebuild() throws Exception {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>();
        if (this.interceptorNames != null) {
            names.addAll(this.interceptorNames);
        }
        names.addAll(this.dynamicInterceptorNames);
        this.log.debug((Object)("Building interceptor stack " + this.getName()));
        PortletInvokerInterceptor[] interceptors = new PortletInvokerInterceptor[names.size()];
        if (names.size() == 1) {
            PortletInvokerInterceptor a;
            ObjectName name = (ObjectName)names.get(0);
            this.log.debug((Object)("Adding interceptor " + name + " to the stack"));
            interceptors[0] = a = (PortletInvokerInterceptor)this.server.getAttribute(name, "ManagedResource");
        }
        for (int i = 0; i < names.size() - 1; ++i) {
            ObjectName name = (ObjectName)names.get(i);
            this.log.debug((Object)("Adding interceptor " + name + " to the stack"));
            PortletInvokerInterceptor a = (PortletInvokerInterceptor)this.server.getAttribute(name, "ManagedResource");
            name = (ObjectName)names.get(i + 1);
            this.log.debug((Object)("Adding interceptor " + name + " to the stack"));
            PortletInvokerInterceptor b = (PortletInvokerInterceptor)this.server.getAttribute(name, "ManagedResource");
            a.setNext((PortletInvoker)b);
            interceptors[i] = a;
            interceptors[i + 1] = b;
        }
        this.stack = new JBossPortletInterceptorStack(interceptors);
    }

    public void stopService() {
        this.stack = JBossPortletInterceptorStack.EMPTY_STACK;
    }

    @Override
    public PortletInterceptorStack getInterceptorStack() {
        return this.stack;
    }
}

