/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.faces.component.UICommand;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.log4j.Logger;

public class ActionEventDispatcher {
    private static final ActionListener[] EMPTY_LISTENERS = new ActionListener[0];
    private static final Logger log = Logger.getLogger(ActionEventDispatcher.class);
    private final UICommand command;

    public ActionEventDispatcher(UICommand command) {
        this.command = command;
    }

    public void dispatch(final FacesContext faces, final ActionEvent event) throws AbortProcessingException {
        ArrayList<ActionListener> listeners = new ArrayList<ActionListener>();
        if (this.command.getActionListeners() != null) {
            listeners.addAll(Arrays.asList(this.command.getActionListeners()));
        }
        if (this.command.getActionListener() != null) {
            ActionListener listener = new ActionListener(){

                public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
                    try {
                        ActionEventDispatcher.this.command.getActionListener().invoke(faces, new Object[]{event});
                    }
                    catch (EvaluationException e) {
                        Throwable cause = e.getCause();
                        if (cause != null && cause instanceof AbortProcessingException) {
                            throw (AbortProcessingException)cause;
                        }
                        log.error((Object)"Was not able to evaluate the method binding", (Throwable)e);
                    }
                }
            };
            listeners.add(listener);
        }
        for (ActionListener listener : listeners) {
            listener.processAction(event);
        }
    }
}

