/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

public class AccessLogValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(AccessLogValve.class);
    private String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.AccessLogValve/2.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected boolean enabled = true;
    protected String pattern = null;
    protected String prefix = "access_log.";
    protected boolean rotatable = true;
    private boolean buffered = true;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected boolean started = false;
    protected String suffix = "";
    protected PrintWriter writer = null;
    protected SimpleDateFormat fileDateFormatter = null;
    private SimpleDateFormat dayFormatter = null;
    private SimpleDateFormat monthFormatter = null;
    private SimpleDateFormat yearFormatter = null;
    private SimpleDateFormat timeFormatter = null;
    private TimeZone timezone = null;
    private String timeZoneNoDST = null;
    private String timeZoneDST = null;
    protected File currentLogFile = null;
    private Date currentDate = null;
    private long currentMillis = 0L;
    private boolean resolveHosts = false;
    private long rotationLastChecked = 0L;
    private boolean checkExists = false;
    protected String condition = null;
    protected String fileDateFormat = null;
    protected AccessLogElement[] logElements = null;

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals("common")) {
            pattern = "%h %l %u %t \"%r\" %s %b";
        }
        if (pattern.equals("combined")) {
            pattern = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        this.pattern = pattern;
        this.logElements = this.createLogElements();
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean checkExists) {
        this.checkExists = checkExists;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public void backgroundProcess() {
        if (this.started && this.getEnabled() && this.writer != null && this.buffered) {
            this.writer.flush();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.started && this.getEnabled()) {
            long t1 = System.currentTimeMillis();
            this.getNext().invoke(request, response);
            long t2 = System.currentTimeMillis();
            long time = t2 - t1;
            if (this.logElements == null || this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
                return;
            }
            Date date = this.getDate();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < this.logElements.length; ++i) {
                this.logElements[i].addElement(result, date, request, response, time);
            }
            this.log(result.toString());
        } else {
            this.getNext().invoke(request, response);
        }
    }

    public synchronized boolean rotate(String newFileName) {
        if (this.currentLogFile != null) {
            File holder = this.currentLogFile;
            this.close();
            try {
                holder.renameTo(new File(newFileName));
            }
            catch (Throwable e) {
                log.error((Object)"rotate failed", e);
            }
            this.currentDate = new Date(System.currentTimeMillis());
            this.dateStamp = this.fileDateFormatter.format(this.currentDate);
            this.open();
            return true;
        }
        return false;
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            this.currentDate = new Date(systime);
            this.rotationLastChecked = systime;
            String tsDate = this.fileDateFormatter.format(this.currentDate);
            if (!this.dateStamp.equals(tsDate)) {
                AccessLogValve accessLogValve = this;
                synchronized (accessLogValve) {
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        if (this.checkExists) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close();
                    }
                    catch (Throwable e) {
                        log.info((Object)"at least this wasn't swallowed", e);
                    }
                    this.currentDate = new Date(System.currentTimeMillis());
                    this.dateStamp = this.fileDateFormatter.format(this.currentDate);
                    this.open();
                }
            }
        }
        if (this.writer != null) {
            this.writer.println(message);
            if (!this.buffered) {
                this.writer.flush();
            }
        }
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    protected synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(pathname, true), 128000), false);
            this.currentLogFile = new File(pathname);
        }
        catch (IOException e) {
            this.writer = null;
            this.currentLogFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentMillis > 1000L) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (systime - this.currentMillis > 1000L) {
                    this.currentDate = new Date(systime);
                    this.currentMillis = systime;
                }
            }
        }
        return this.currentDate;
    }

    private String getTimeZone(Date date) {
        if (this.timezone.inDaylightTime(date)) {
            return this.timeZoneDST;
        }
        return this.timeZoneNoDST;
    }

    private String calculateTimeZoneOffset(long offset) {
        StringBuffer tz = new StringBuffer();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.timezone = TimeZone.getDefault();
        this.timeZoneNoDST = this.calculateTimeZoneOffset(this.timezone.getRawOffset());
        Calendar calendar = Calendar.getInstance(this.timezone);
        int offset = calendar.get(16);
        this.timeZoneDST = this.calculateTimeZoneOffset(this.timezone.getRawOffset() + offset);
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        this.fileDateFormatter = new SimpleDateFormat(this.fileDateFormat);
        this.fileDateFormatter.setTimeZone(this.timezone);
        this.dayFormatter = new SimpleDateFormat("dd");
        this.dayFormatter.setTimeZone(this.timezone);
        this.monthFormatter = new SimpleDateFormat("MM");
        this.monthFormatter.setTimeZone(this.timezone);
        this.yearFormatter = new SimpleDateFormat("yyyy");
        this.yearFormatter.setTimeZone(this.timezone);
        this.timeFormatter = new SimpleDateFormat("HH:mm:ss");
        this.timeFormatter.setTimeZone(this.timezone);
        this.currentDate = new Date();
        this.dateStamp = this.fileDateFormatter.format(this.currentDate);
        this.open();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> list = new ArrayList<AccessLogElement>();
        boolean replace = false;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char ch = this.pattern.charAt(i);
            if (replace) {
                if ('{' == ch) {
                    int j;
                    StringBuffer name = new StringBuffer();
                    for (j = i + 1; j < this.pattern.length() && '}' != this.pattern.charAt(j); ++j) {
                        name.append(this.pattern.charAt(j));
                    }
                    if (j + 1 < this.pattern.length()) {
                        list.add(this.createAccessLogElement(name.toString(), this.pattern.charAt(++j)));
                        i = j;
                    } else {
                        list.add(this.createAccessLogElement(ch));
                    }
                } else {
                    list.add(this.createAccessLogElement(ch));
                }
                replace = false;
                continue;
            }
            if (ch == '%') {
                replace = true;
                list.add(new StringElement(buf.toString()));
                buf = new StringBuffer();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(new StringElement(buf.toString()));
        }
        return list.toArray(new AccessLogElement[0]);
    }

    private AccessLogElement createAccessLogElement(String header, char pattern) {
        switch (pattern) {
            case 'i': {
                return new HeaderElement(header);
            }
            case 'c': {
                return new CookieElement(header);
            }
            case 'r': {
                return new RequestAttributeElement(header);
            }
            case 's': {
                return new SessionAttributeElement(header);
            }
        }
        return new StringElement("???");
    }

    private AccessLogElement createAccessLogElement(char pattern) {
        switch (pattern) {
            case 'a': {
                return new RemoteAddrElement();
            }
            case 'A': {
                return new LocalAddrElement();
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'D': {
                return new ElapsedTimeElement(true);
            }
            case 'h': {
                return new HostElement();
            }
            case 'H': {
                return new ProtocolElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'p': {
                return new LocalPortElement();
            }
            case 'q': {
                return new QueryElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'S': {
                return new SessionIdElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'T': {
                return new ElapsedTimeElement(false);
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
        }
        return new StringElement("???" + pattern + "???");
    }

    protected class SessionAttributeElement
    implements AccessLogElement {
        private String header;

        public SessionAttributeElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            Object value = null;
            if (null != request) {
                HttpSession sess = request.getSession(false);
                if (null != sess) {
                    value = sess.getAttribute(this.header);
                }
            } else {
                value = "??";
            }
            if (value != null) {
                if (value instanceof String) {
                    buf.append((String)value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class RequestAttributeElement
    implements AccessLogElement {
        private String header;

        public RequestAttributeElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            Object value = null;
            value = request != null ? request.getAttribute(this.header) : "??";
            if (value != null) {
                if (value instanceof String) {
                    buf.append((String)value);
                } else {
                    buf.append(value.toString());
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class CookieElement
    implements AccessLogElement {
        private String header;

        public CookieElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            String value = "-";
            Cookie[] c = request.getCookies();
            if (c != null) {
                for (int i = 0; i < c.length; ++i) {
                    if (!this.header.equals(c[i].getName())) continue;
                    value = c[i].getValue();
                    break;
                }
            }
            buf.append(value);
        }
    }

    protected class HeaderElement
    implements AccessLogElement {
        private String header;

        public HeaderElement(String header) {
            this.header = header;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getHeader(this.header));
        }
    }

    protected class StringElement
    implements AccessLogElement {
        private String str;

        public StringElement(String str) {
            this.str = str;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(this.str);
        }
    }

    protected class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getServerName());
        }
    }

    protected class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                buf.append(request.getRequestURI());
            } else {
                buf.append('-');
            }
        }
    }

    protected class SessionIdElement
    implements AccessLogElement {
        protected SessionIdElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                if (request.getSession(false) != null) {
                    buf.append(request.getSessionInternal(false).getIdInternal());
                } else {
                    buf.append('-');
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class QueryElement
    implements AccessLogElement {
        protected QueryElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            String query = null;
            if (request != null) {
                query = request.getQueryString();
            }
            if (query != null) {
                buf.append('?');
                buf.append(query);
            }
        }
    }

    protected class ElapsedTimeElement
    implements AccessLogElement {
        private boolean millis;

        public ElapsedTimeElement(boolean millis) {
            this.millis = millis;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (this.millis) {
                buf.append(time);
            } else {
                buf.append(time / 1000L);
                buf.append('.');
                int remains = (int)(time % 1000L);
                buf.append(remains / 100);
                buf.append((remains %= 100) / 10);
                buf.append(remains % 10);
            }
        }
    }

    protected class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                buf.append(request.getMethod());
            }
        }
    }

    protected class ByteSentElement
    implements AccessLogElement {
        private boolean conversion;

        public ByteSentElement(boolean conversion) {
            this.conversion = conversion;
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            int length = response.getContentCount();
            if (length <= 0 && this.conversion) {
                buf.append('-');
            } else {
                buf.append(length);
            }
        }
    }

    protected class LocalPortElement
    implements AccessLogElement {
        protected LocalPortElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getServerPort());
        }
    }

    protected class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (response != null) {
                buf.append(response.getStatus());
            } else {
                buf.append('-');
            }
        }
    }

    protected class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                buf.append(request.getMethod());
                buf.append(' ');
                buf.append(request.getRequestURI());
                if (request.getQueryString() != null) {
                    buf.append('?');
                    buf.append(request.getQueryString());
                }
                buf.append(' ');
                buf.append(request.getProtocol());
            } else {
                buf.append("- - ");
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        private Date currentDate = new Date(0L);
        private String currentDateString = null;

        protected DateAndTimeElement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (this.currentDate != date) {
                DateAndTimeElement dateAndTimeElement = this;
                synchronized (dateAndTimeElement) {
                    if (this.currentDate != date) {
                        StringBuffer current = new StringBuffer(32);
                        current.append('[');
                        current.append(AccessLogValve.this.dayFormatter.format(date));
                        current.append('/');
                        current.append(AccessLogValve.this.lookup(AccessLogValve.this.monthFormatter.format(date)));
                        current.append('/');
                        current.append(AccessLogValve.this.yearFormatter.format(date));
                        current.append(':');
                        current.append(AccessLogValve.this.timeFormatter.format(date));
                        current.append(' ');
                        current.append(AccessLogValve.this.getTimeZone(date));
                        current.append(']');
                        this.currentDateString = current.toString();
                        this.currentDate = date;
                    }
                }
            }
            buf.append(this.currentDateString);
        }
    }

    protected class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (request != null) {
                String value = request.getRemoteUser();
                if (value != null) {
                    buf.append(value);
                } else {
                    buf.append('-');
                }
            } else {
                buf.append('-');
            }
        }
    }

    protected class ProtocolElement
    implements AccessLogElement {
        protected ProtocolElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getProtocol());
        }
    }

    protected class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append('-');
        }
    }

    protected class HostElement
    implements AccessLogElement {
        protected HostElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getRemoteHost());
        }
    }

    protected class RemoteAddrElement
    implements AccessLogElement {
        protected RemoteAddrElement() {
        }

        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            buf.append(request.getRemoteAddr());
        }
    }

    protected class LocalAddrElement
    implements AccessLogElement {
        private String value = null;

        protected LocalAddrElement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(StringBuffer buf, Date date, Request request, Response response, long time) {
            if (this.value == null) {
                LocalAddrElement localAddrElement = this;
                synchronized (localAddrElement) {
                    try {
                        this.value = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (Throwable e) {
                        this.value = "127.0.0.1";
                    }
                }
            }
            buf.append(this.value);
        }
    }

    protected static interface AccessLogElement {
        public void addElement(StringBuffer var1, Date var2, Request var3, Response var4, long var5);
    }
}

