/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller;

import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.controller.PortletController;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.RequestHandler;
import org.jboss.portal.portlet.controller.request.PortletResourceRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.response.ResourceResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.PortletInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortletResourceRequestHandler
extends RequestHandler<PortletResourceRequest> {
    public PortletResourceRequestHandler(PortletController controller) {
        super(PortletResourceRequest.class, controller);
    }

    @Override
    ControllerResponse processResponse(PortletControllerContext controllerContext, PortletResourceRequest request, PortletInvocationResponse response) throws PortletInvokerException {
        return new ResourceResponse(response);
    }

    @Override
    PortletInvocationResponse invoke(PortletControllerContext context, PortletResourceRequest portletResourceRequest) throws PortletInvokerException {
        CacheLevel cacheability;
        Mode mode = null;
        WindowState windowState = null;
        PortletPageNavigationalState pageNavigationalState = null;
        Map<String, String[]> publicNS = null;
        StateString portletNS = null;
        PortletResourceRequest.Scope scope = portletResourceRequest.getScope();
        if (scope instanceof PortletResourceRequest.PortletScope) {
            PortletResourceRequest.PortletScope portletScope = (PortletResourceRequest.PortletScope)scope;
            PortletWindowNavigationalState navigationalState = portletScope.getWindowNavigationalState();
            if (navigationalState != null) {
                mode = navigationalState.getMode();
                windowState = navigationalState.getWindowState();
                portletNS = navigationalState.getPortletNavigationalState();
            }
            if (scope instanceof PortletResourceRequest.PageScope) {
                PortletResourceRequest.PageScope pageScope = (PortletResourceRequest.PageScope)scope;
                pageNavigationalState = pageScope.getPageNavigationalState();
                cacheability = CacheLevel.PAGE;
                if (pageNavigationalState != null) {
                    publicNS = pageNavigationalState.getPortletPublicNavigationalState(portletResourceRequest.getWindowId());
                }
            } else {
                cacheability = CacheLevel.PORTLET;
            }
        } else {
            cacheability = CacheLevel.FULL;
        }
        if (mode == null) {
            mode = Mode.VIEW;
        }
        if (windowState == null) {
            windowState = WindowState.NORMAL;
        }
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(portletResourceRequest.getWindowId(), pageNavigationalState);
        ResourceInvocation resourceInvocation = new ResourceInvocation(portletInvocationContext);
        resourceInvocation.setResourceId(portletResourceRequest.getResourceId());
        resourceInvocation.setCacheLevel(cacheability);
        resourceInvocation.setMode(mode);
        resourceInvocation.setWindowState(windowState);
        resourceInvocation.setNavigationalState(portletNS);
        resourceInvocation.setPublicNavigationalState(publicNS);
        resourceInvocation.setResourceState(portletResourceRequest.getResourceState());
        resourceInvocation.setForm(portletResourceRequest.getBodyParameters() != null ? ParameterMap.clone(portletResourceRequest.getBodyParameters()) : null);
        try {
            return context.invoke(resourceInvocation);
        }
        catch (PortletInvokerException e) {
            return null;
        }
    }
}

