/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.netvibes.provider;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.widget.WidgetQuery;
import org.jboss.portal.widget.exceptions.WidgetException;
import org.jboss.portal.widget.netvibes.directory.NVEcosystemFactory;
import org.jboss.portal.widget.netvibes.directory.NVQueryResultMetaData;
import org.jboss.portal.widget.netvibes.provider.NetvibesQueryResult;
import org.jboss.portal.widget.netvibes.provider.NetvibesQueryResultEntry;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class NetvibesQueryResultBuilder {
    private static final Logger log = Logger.getLogger(NetvibesQueryResultBuilder.class);
    private final URL url;

    public NetvibesQueryResultBuilder(WidgetQuery query) throws MalformedURLException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null.");
        }
        this.url = query.buildQueryURL();
    }

    public NetvibesQueryResultBuilder(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetvibesQueryResult build(int connectionTimeout) throws WidgetException {
        try {
            byte[] bytes;
            if ("http".equals(this.url.getProtocol())) {
                bytes = URLTools.getContent((URL)this.url, (int)connectionTimeout, (int)connectionTimeout);
            } else {
                InputStream in = this.url.openStream();
                try {
                    bytes = IOTools.getBytes((InputStream)in);
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                }
            }
            if (bytes == null) {
                throw new WidgetException("Cannot retrieve url: " + this.url);
            }
            String string = new String(bytes);
            List data = null;
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            NVEcosystemFactory factory = new NVEcosystemFactory();
            data = (List)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), (ObjectModelFactory)factory, null);
            ArrayList<NetvibesQueryResultEntry> entries = new ArrayList<NetvibesQueryResultEntry>();
            for (NVQueryResultMetaData meta : data) {
                NetvibesQueryResultEntry entry = new NetvibesQueryResultEntry(meta);
                entries.add(entry);
            }
            return new NetvibesQueryResult(entries);
        }
        catch (SocketTimeoutException e) {
            throw new WidgetException("Netvibes directory query failed due to timeout. Try to increase connectionTimeout initial parameter; ", (Throwable)e);
        }
        catch (JBossXBException e) {
            throw new WidgetException("Failed to parse directory response.", (Throwable)e);
        }
        catch (IOException e) {
            throw new WidgetException("Failed to perform directory lookup.", (Throwable)e);
        }
    }
}

