/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.jboss.logging.Logger;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.identity.services.metadata.UIComponentConfiguration;
import org.jboss.portal.core.identity.ui.IdentityUIUser;
import org.jboss.portal.core.identity.ui.common.MetaDataServiceBean;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portlet.JBossActionRequest;
import org.jboss.portlet.JBossRenderRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityUserBean {
    private UserModule userModule;
    private UserProfileModule userProfileModule;
    private MetaDataServiceBean metaDataService;
    private static final Logger log = Logger.getLogger(IdentityUserBean.class);

    public UserModule getUserModule() {
        return this.userModule;
    }

    public void setUserModule(UserModule userModule) {
        this.userModule = userModule;
    }

    public UserProfileModule getUserProfileModule() {
        return this.userProfileModule;
    }

    public void setUserProfileModule(UserProfileModule userProfileModule) {
        this.userProfileModule = userProfileModule;
    }

    public MetaDataServiceBean getMetaDataService() {
        return this.metaDataService;
    }

    public void setMetaDataService(MetaDataServiceBean metaDataService) {
        this.metaDataService = metaDataService;
    }

    public Map<String, Object> getProfileMap(Map<String, Object> attributeMap) {
        HashMap<String, Object> profileMap = new HashMap<String, Object>();
        for (String key : attributeMap.keySet()) {
            Object value = attributeMap.get(key);
            UIComponentConfiguration uiComponent = (UIComponentConfiguration)this.metaDataService.getValue(key).getObject();
            if (uiComponent == null) continue;
            profileMap.put(uiComponent.getPropertyRef(), value);
        }
        return profileMap;
    }

    public void updateProfile(User user, Map<String, Object> attributeMap) {
        Map<String, Object> profileMap = this.getProfileMap(attributeMap);
        for (String key : profileMap.keySet()) {
            Object value = profileMap.get(key);
            try {
                this.userProfileModule.setProperty(user, key, value);
            }
            catch (Exception e) {
                log.error((Object)"updateProfile failed", (Throwable)e);
            }
        }
    }

    public User findUserByUserName(String username) throws IllegalArgumentException, NoSuchUserException, IdentityException {
        return this.userModule.findUserByUserName(username);
    }

    public List<IdentityUIUser> findUsersFilteredByUserName(String filter, int offset, int limit) throws IllegalArgumentException, IdentityException {
        Set users = new HashSet();
        ArrayList<IdentityUIUser> list = new ArrayList<IdentityUIUser>();
        users = this.userModule.findUsersFilteredByUserName(filter, offset, limit);
        for (User user : users) {
            IdentityUIUser uiUser = new IdentityUIUser(user.getUserName());
            list.add(uiUser);
        }
        Collections.sort(list, new IdentityUIUserComparator());
        return list;
    }

    public void updatePassword(String username, String password) throws IllegalArgumentException, IdentityException, IdentityException {
        User user = this.userModule.findUserByUserName(username);
        user.updatePassword(password);
    }

    public Object getLocalizedValue(String propertyName, Object value) {
        UIComponentConfiguration uiComponent = (UIComponentConfiguration)this.metaDataService.getValue(propertyName).getObject();
        if (uiComponent.getValues() != null && value instanceof String && uiComponent.getValues().size() > 0) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", FacesContext.getCurrentInstance().getViewRoot().getLocale());
                return bundle.getString("IDENTITY_DYNAMIC_VALUE_" + ((String)value).toUpperCase());
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }

    public Class getPropertyType(String propertyName) throws IdentityException, ClassNotFoundException {
        UIComponentConfiguration uiComponent = (UIComponentConfiguration)this.metaDataService.getValue(propertyName).getObject();
        return uiComponent.getPropertyClass();
    }

    public Object getUserProperty(String username, String propertyName) throws IllegalArgumentException, NoSuchUserException, IdentityException {
        UIComponentConfiguration uiComponent = (UIComponentConfiguration)this.metaDataService.getValue(propertyName).getObject();
        Map profile = null;
        if (profile == null) {
            User user = this.getCurrentUser();
            if (user == null || !user.getUserName().equals(username)) {
                user = this.findUserByUserName(username);
            }
            return this.userProfileModule.getProperty(user, uiComponent.getPropertyRef());
        }
        return profile.get(uiComponent.getPropertyRef());
    }

    public User getCurrentUser() {
        Object user;
        Object request = FacesContext.getCurrentInstance().getExternalContext().getRequest();
        ControllerContext context = null;
        if (request instanceof JBossRenderRequest) {
            JBossRenderRequest renderRequest = (JBossRenderRequest)request;
            context = renderRequest.getControllerContext();
        } else if (request instanceof JBossActionRequest) {
            JBossActionRequest actionRequest = (JBossActionRequest)request;
            context = actionRequest.getControllerContext();
        }
        if (context != null && (user = context.getAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)"user")) instanceof User) {
            return (User)user;
        }
        return null;
    }

    public Map getCachedUserProfile() {
        Object profile;
        Object request = FacesContext.getCurrentInstance().getExternalContext().getRequest();
        ControllerContext context = null;
        if (request instanceof JBossRenderRequest) {
            JBossRenderRequest renderRequest = (JBossRenderRequest)request;
            context = renderRequest.getControllerContext();
        } else if (request instanceof JBossActionRequest) {
            JBossActionRequest actionRequest = (JBossActionRequest)request;
            context = actionRequest.getControllerContext();
        }
        if (context != null && (profile = context.getAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)"profile")) instanceof Map) {
            return (Map)profile;
        }
        return null;
    }

    protected class IdentityUIUserComparator
    implements Comparator {
        protected IdentityUIUserComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                IdentityUIUser u1 = (IdentityUIUser)o1;
                IdentityUIUser u2 = (IdentityUIUser)o2;
                return u1.getUsername().compareToIgnoreCase(u2.getUsername());
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

