/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import javax.xml.namespace.QName;
import org.jboss.portal.core.admin.ui.coordination.CoordinationManagerBean;
import org.jboss.portal.core.admin.ui.coordination.QNameSelectItem;
import org.jboss.portal.core.controller.coordination.EventWiringInfo;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.info.EventInfo;
import org.jboss.portal.portlet.info.EventingInfo;
import org.jboss.portal.portlet.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventWiringManagerBean
extends CoordinationManagerBean.CoordinationBean {
    private Map<String, DisplayEventWiring> displayEventWirings;
    private Map<QNameSelectItem, SortedSet<WindowSelectItem>> eventNameToWindowSources;
    private Map<QNameSelectItem, SortedSet<WindowSelectItem>> eventNameToWindowDestinations;
    private String selectedSourceEvent;
    private List<String> selectedSourceWindows;
    private String selectedDestinationEvent;
    private List<String> selectedDestinationWindows;
    private EventWiringInfoCreator currentWiring;

    public EventWiringManagerBean() {
    }

    public EventWiringManagerBean(CoordinationManagerBean managerBean) {
        super(managerBean);
    }

    @Override
    public boolean loadInfoFrom(Page page) {
        Collection wiringInfos = this.managerBean.getCoordinationService().getEventWirings(page);
        if (!wiringInfos.isEmpty()) {
            this.displayEventWirings = new HashMap<String, DisplayEventWiring>(wiringInfos.size());
            for (EventWiringInfo ewInfo : wiringInfos) {
                this.displayEventWirings.put(ewInfo.getName(), new DisplayEventWiring(ewInfo));
            }
            return true;
        }
        this.displayEventWirings = Collections.emptyMap();
        return false;
    }

    private Map<QNameSelectItem, SortedSet<WindowSelectItem>> addEventInfoFor(Window window, Map<QName, ? extends EventInfo> windowEvents, Map<QNameSelectItem, SortedSet<WindowSelectItem>> existing) {
        if (windowEvents != null && !windowEvents.isEmpty()) {
            if (existing == null) {
                existing = new HashMap<QNameSelectItem, SortedSet<WindowSelectItem>>();
            }
            for (QName qName : windowEvents.keySet()) {
                QNameSelectItem item = new QNameSelectItem(qName);
                SortedSet<WindowSelectItem> windows = existing.get(item);
                if (windows == null) {
                    windows = new TreeSet<WindowSelectItem>();
                    existing.put(item, windows);
                }
                windows.add(new WindowSelectItem(window));
            }
        }
        return existing;
    }

    public String getStep2Message() {
        return this.beanContext.getMessageFromBundle("COORDINATION_EVENT_CREATE_STEP2", new Object[]{this.selectedSourceEvent});
    }

    public String getStep4Message() {
        return this.beanContext.getMessageFromBundle("COORDINATION_EVENT_CREATE_STEP4", new Object[]{this.selectedDestinationEvent});
    }

    public Collection<DisplayEventWiring> getDisplayEventWirings() {
        if (this.displayEventWirings == null || this.displayEventWirings.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<DisplayEventWiring> result = new LinkedList<DisplayEventWiring>(this.displayEventWirings.values());
        Collections.sort(result);
        return result;
    }

    public List<QNameSelectItem> getSourceEvents() {
        if (this.currentWiring == null) {
            this.currentWiring = new EventWiringInfoCreator(this.managerBean.getSelectedPage());
        }
        return this.getPossibleEvents(this.eventNameToWindowSources);
    }

    public List<QNameSelectItem> getDestinationEvents() {
        Map<Window, QName> sources = this.getMappingForWiring(this.selectedSourceWindows, this.selectedSourceEvent);
        this.currentWiring.setSources(sources);
        return this.getPossibleEvents(this.eventNameToWindowDestinations);
    }

    private List<QNameSelectItem> getPossibleEvents(Map<QNameSelectItem, SortedSet<WindowSelectItem>> eventNameToWindows) {
        if (eventNameToWindows == null) {
            return Collections.emptyList();
        }
        LinkedList<QNameSelectItem> result = new LinkedList<QNameSelectItem>();
        result.addAll(eventNameToWindows.keySet());
        Collections.sort(result);
        return result;
    }

    private Map<Window, QName> getMappingForWiring(List<String> selectedWindows, String selectedEvent) {
        if (selectedWindows != null) {
            Page selectedPage = this.managerBean.getSelectedPage();
            if (selectedPage == null) {
                throw new IllegalStateException("A page should have been selected!");
            }
            HashMap<Window, QName> windowQNameMap = new HashMap<Window, QName>(selectedWindows.size());
            for (String windowName : selectedWindows) {
                Window window = (Window)selectedPage.getChild(windowName);
                windowQNameMap.put(window, QName.valueOf(selectedEvent));
            }
            return windowQNameMap;
        }
        return Collections.emptyMap();
    }

    public List<WindowSelectItem> getSourceWindows() {
        return this.getPossibleWindows(this.eventNameToWindowSources, this.selectedSourceEvent);
    }

    public List<WindowSelectItem> getDestinationWindows() {
        return this.getPossibleWindows(this.eventNameToWindowDestinations, this.selectedDestinationEvent);
    }

    private List<WindowSelectItem> getPossibleWindows(Map<QNameSelectItem, SortedSet<WindowSelectItem>> eventNameToWindows, String selectedEventName) {
        if (eventNameToWindows == null) {
            return Collections.emptyList();
        }
        if (selectedEventName != null) {
            LinkedList<WindowSelectItem> result = new LinkedList<WindowSelectItem>();
            result.addAll((Collection)eventNameToWindows.get(new QNameSelectItem(QName.valueOf(selectedEventName))));
            Collections.sort(result);
            return result;
        }
        return Collections.emptyList();
    }

    public String getSelectedSourceEvent() {
        return this.selectedSourceEvent;
    }

    public void setSelectedSourceEvent(String selectedSourceEvent) {
        this.selectedSourceEvent = selectedSourceEvent;
    }

    public List<String> getSelectedSourceWindows() {
        return this.selectedSourceWindows;
    }

    public void setSelectedSourceWindows(List<String> selectedSourceWindows) {
        this.selectedSourceWindows = selectedSourceWindows;
    }

    public String getSelectedDestinationEvent() {
        return this.selectedDestinationEvent;
    }

    public void setSelectedDestinationEvent(String selectedDestinationEvent) {
        this.selectedDestinationEvent = selectedDestinationEvent;
    }

    public List<String> getSelectedDestinationWindows() {
        return this.selectedDestinationWindows;
    }

    public void setSelectedDestinationWindows(List<String> selectedDestinationWindows) {
        this.selectedDestinationWindows = selectedDestinationWindows;
    }

    public String getWiringName() {
        if (this.currentWiring == null) {
            return null;
        }
        return this.currentWiring.getName();
    }

    public void setWiringName(String eventWiringName) {
        if (this.currentWiring != null) {
            this.currentWiring.setName(eventWiringName);
            Map<Window, QName> destinations = this.getMappingForWiring(this.selectedDestinationWindows, this.selectedDestinationEvent);
            this.currentWiring.setDestinations(destinations);
        }
    }

    @Override
    protected void internalRename(String oldName, String newName) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().renameEventWiring(this.managerBean.getSelectedPage(), oldName, newName);
    }

    @Override
    protected void internalCreate() throws IllegalCoordinationException {
        if (this.currentWiring != null) {
            this.managerBean.getCoordinationService().setEventWiring(this.currentWiring.getSources(), this.currentWiring.getDestinations(), this.currentWiring.getName());
        }
    }

    @Override
    protected String getBeanName() {
        return this.currentWiring != null ? this.currentWiring.getName() : null;
    }

    @Override
    public String resetSelection() {
        this.currentWiring = null;
        this.selectedSourceEvent = null;
        this.selectedSourceWindows = null;
        this.selectedDestinationEvent = null;
        this.selectedDestinationWindows = null;
        return super.resetSelection();
    }

    @Override
    public String delete(String name) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().removeEventWiring(this.managerBean.getSelectedPage(), name);
        return this.resetSelection();
    }

    @Override
    public void extractInfoFrom(Window window, PortletInfo info) {
        EventingInfo eventingInfo = info.getEventing();
        this.eventNameToWindowSources = this.addEventInfoFor(window, eventingInfo.getProducedEvents(), this.eventNameToWindowSources);
        this.eventNameToWindowDestinations = this.addEventInfoFor(window, eventingInfo.getConsumedEvents(), this.eventNameToWindowDestinations);
    }

    @Override
    public void initKnowing(Collection<PortalObject> children) {
    }

    @Override
    public String getObjectTypeName() {
        return "COORDINATION_WIRING";
    }

    @Override
    public String getObjectNameForMessages() {
        return "wiring";
    }

    @Override
    protected String getAdditionalFormId() {
        return "COORDINATION_EVENT_CREATE_STEP5:";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.displayEventWirings.containsKey(objectName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventWiringInfoCreator
    implements EventWiringInfo {
        private String name;
        private Map<Window, QName> sources;
        private Map<Window, QName> destinations;
        private final Page page;

        private EventWiringInfoCreator(Page page) {
            this.page = page;
        }

        public Page getPage() {
            return this.page;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<Window, QName> getSources() {
            return this.sources;
        }

        public void setSources(Map<Window, QName> sources) {
            this.sources = sources;
        }

        public Map<Window, QName> getDestinations() {
            return this.destinations;
        }

        public void setDestinations(Map<Window, QName> destinations) {
            this.destinations = destinations;
        }
    }

    public static class WindowSelectItem
    extends SelectItem
    implements Comparable {
        public WindowSelectItem(Window window) {
            super((Object)window.getName(), window.getName());
        }

        public int compareTo(Object o) {
            WindowSelectItem other = (WindowSelectItem)o;
            return this.getLabel().compareTo(other.getLabel());
        }

        public int hashCode() {
            return this.getLabel().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WindowSelectItem) {
                return false;
            }
            WindowSelectItem item = (WindowSelectItem)obj;
            return this.getLabel().equals(item.getLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayEventWiring
    implements Comparable {
        private List<Window> sourceWindows;
        private List<QName> sourceEvents;
        private List<Window> destinationWindows;
        private List<QName> destinationEvents;
        private EventWiringInfo eventInfo;

        DisplayEventWiring(EventWiringInfo eventInfo) {
            this.eventInfo = eventInfo;
            Map sources = eventInfo.getSources();
            this.sourceWindows = new ArrayList(sources.keySet());
            this.sourceEvents = new ArrayList(new HashSet(sources.values()));
            Map destinations = eventInfo.getDestinations();
            this.destinationWindows = new ArrayList(destinations.keySet());
            this.destinationEvents = new ArrayList(new HashSet(destinations.values()));
        }

        public EventWiringInfo getEventInfo() {
            return this.eventInfo;
        }

        public String getName() {
            return this.eventInfo.getName();
        }

        public List<Window> getSourceWindows() {
            return this.sourceWindows;
        }

        public List<QName> getSourceEvents() {
            return this.sourceEvents;
        }

        public List<Window> getDestinationWindows() {
            return this.destinationWindows;
        }

        public List<QName> getDestinationEvents() {
            return this.destinationEvents;
        }

        public int compareTo(Object o) {
            DisplayEventWiring other = (DisplayEventWiring)o;
            return this.getName().compareTo(other.getName());
        }
    }
}

