/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.utils;

import com.octo.captcha.CaptchaException;
import java.awt.Toolkit;

public class ToolkitFactory {
    public static String TOOLKIT_IMPL = "toolkit.implementation";
    private static String toolkitClass;

    public static Toolkit getToolkit() {
        Toolkit defaultToolkit = null;
        try {
            String tempToolkitClass = System.getProperty(TOOLKIT_IMPL);
            if (tempToolkitClass != null) {
                defaultToolkit = (Toolkit)Class.forName(tempToolkitClass).newInstance();
                toolkitClass = tempToolkitClass;
            } else {
                defaultToolkit = ToolkitFactory.getDefaultToolkit();
            }
        }
        catch (Throwable e) {
            throw new CaptchaException("toolkit has not been abble to be initialized", e);
        }
        return defaultToolkit;
    }

    private static Toolkit getDefaultToolkit() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        toolkitClass = defaultToolkit.getClass().getName();
        return defaultToolkit;
    }
}

