/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.mx;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.portal.common.mx.ListenerException;

public class Listener
implements NotificationFilter,
NotificationListener {
    private static final long serialVersionUID = 444957117668223654L;
    protected final MBeanServer server;
    protected final Logger log;

    public Listener(MBeanServer server) {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        this.server = server;
        this.log = Logger.getLogger(this.getClass());
    }

    public void register(ObjectName broadcaster) {
        this.register(broadcaster, null);
    }

    public void register(ObjectName broadcaster, Object handback) {
        try {
            if (broadcaster == null) {
                throw new IllegalArgumentException("Broadcaster is null");
            }
            this.log.debug((Object)("Register notifications on MBean " + broadcaster.getCanonicalName()));
            this.server.addNotificationListener(broadcaster, this, (NotificationFilter)this, handback);
        }
        catch (InstanceNotFoundException e) {
            throw new ListenerException(e);
        }
    }

    public void unregister(ObjectName broadcaster) {
        try {
            if (broadcaster == null) {
                throw new IllegalArgumentException("Broadcaster is null");
            }
            this.log.debug((Object)("Unregister notifications on MBean " + broadcaster.getCanonicalName()));
            this.server.removeNotificationListener(broadcaster, this);
        }
        catch (InstanceNotFoundException e) {
            throw new ListenerException(e);
        }
        catch (ListenerNotFoundException e) {
            throw new ListenerException(e);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        return true;
    }

    public void handleNotification(Notification notification, Object handback) {
    }
}

