/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import org.jboss.portal.common.text.EntityEncoder;

public class Exceptions {
    public static Throwable unwrap(Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            throw new IllegalArgumentException("Cannot unwrap null throwable");
        }
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            throwable = current;
        }
        return throwable;
    }

    public static String toHTML(Throwable throwable) {
        return Exceptions.toHTML(throwable, false);
    }

    public static String toHTML(Throwable throwable, boolean deep) {
        StringBuffer tmp = new StringBuffer();
        Exceptions.appendHTMLTo(tmp, throwable, deep);
        return tmp.toString();
    }

    public static void appendHTMLTo(StringBuffer buffer, Throwable throwable) {
        Exceptions.appendHTMLTo(buffer, throwable, false);
    }

    public static void appendHTMLTo(StringBuffer buffer, Throwable throwable, boolean deep) {
        buffer.append("<div><pre style=\"text-align:left;\"><code>");
        while (throwable != null) {
            buffer.append(EntityEncoder.FULL.encode(throwable.toString())).append('\n');
            StackTraceElement[] elts = throwable.getStackTrace();
            for (int j = 0; j < elts.length; ++j) {
                StackTraceElement elt = elts[j];
                buffer.append("\tat ").append(elt).append("\n");
            }
            throwable = throwable.getCause();
        }
        buffer.append("</code></pre></div>");
    }
}

