/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.TimeoutException;
import org.jgroups.util.QueueClosedException;

public class LinkedListQueue {
    final LinkedList l = new LinkedList();
    boolean closed = false;
    final Object mutex = new Object();
    int num_markers = 0;
    private static final Object endMarker = new Object();
    protected static final Log log = LogFactory.getLog((Class)LinkedListQueue.class);

    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) throws QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("LinkedListQueue.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            this.l.add(obj);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("LinkedListQueue.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            this.l.addFirst(obj);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            while (this.l.size() == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                retval = this.l.removeFirst();
                if (this.l.size() == 1 && this.l.getFirst().equals(endMarker)) {
                    this.closed = true;
                }
            }
            catch (NoSuchElementException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("retval == null, size()=" + this.l.size()));
                }
                return null;
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.l.size() == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                retval = this.l.removeFirst();
                if (this.l.size() == 1 && this.l.getFirst().equals(endMarker)) {
                    this.closed = true;
                }
            }
            catch (NoSuchElementException ex) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Object obj) throws QueueClosedException {
        if (obj == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            boolean removed = this.l.remove(obj);
            if (!removed && log.isWarnEnabled()) {
                log.warn((Object)("element " + obj + " was not found in the queue"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() throws QueueClosedException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            while (this.l.size() == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                retval = this.l.getFirst();
            }
            catch (NoSuchElementException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("retval == null, size()=" + this.l.size()));
                }
                return null;
            }
        }
        if (retval == endMarker) {
            this.close(false);
            throw new QueueClosedException();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.l.size() == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            try {
                retval = this.l.getFirst();
            }
            catch (NoSuchElementException ex) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(endMarker);
                ++this.num_markers;
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            block8: {
                this.closed = true;
                try {
                    this.mutex.notifyAll();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error((Object)("exception=" + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.l.clear();
            this.closed = false;
        }
    }

    public int size() {
        return this.l.size() - this.num_markers;
    }

    public String toString() {
        return "LinkedListQueue (" + this.size() + ") messages [closed=" + this.closed + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getContents() {
        Vector retval = new Vector();
        Object object = this.mutex;
        synchronized (object) {
            Iterator it = this.l.iterator();
            while (it.hasNext()) {
                retval.addElement(it.next());
            }
        }
        return retval;
    }
}

